define('jira-agile/rapid/logger', ["jira/util/logger", "underscore"], function (JiraLogger, _) {

    var Logger = {};

    Logger.Contexts = {};

    Logger.Contexts.ajax = 'ajax';
    Logger.Contexts.event = 'event';
    Logger.Contexts.state = 'state';
    Logger.Contexts.ui = 'ui';
    Logger.Contexts.callback = 'callback';
    Logger.Contexts.refresh = 'refresh';

    Logger.enabledContexts = [Logger.Contexts.ajax, Logger.Contexts.event, Logger.Contexts.state, Logger.Contexts.ui, Logger.Contexts.callback, Logger.Contexts.refresh];

    Logger.log = function (msg, context) {
        if (!context || _.contains(Logger.enabledContexts, context)) {
            var logMsg = context ? Logger.pad(context, 6) + ': ' + msg : msg;
            JiraLogger.log(logMsg);
            // Remove log storage because we can't make use of it in Bonfire
            // We could, however, if we pushed it into a meta tag
            //        Logger.store(logMsg);
        }
    };

    Logger.pad = function (str, width) {
        if (str.length < width) {
            return str + "                               ".substr(0, width - str.length);
        }
        return str;
    };

    Logger.timeMap = {};

    // start + stop taken from firebuglite.js - http://getfirebug.com/firebuglite
    Logger.timeStart = function (name) {
        if (!name) {
            throw 'start: If starting a timer manually a name must be set';
        } else {
            Logger.timeMap[name] = new Date().getTime();
        }
    };

    Logger.timeStop = function (name) {
        if (name in Logger.timeMap) {
            var timeElapsed = new Date().getTime() - Logger.timeMap[name];
            delete Logger.timeMap[name];
            Logger.log(timeElapsed + "ms on " + name, Logger.Contexts.ui);
        } else {
            throw 'stop:' + name + ' not found';
        }
    };

    // TODO This could be more efficient
    // Currently unused
    /**
     Logger.storage = [];
     Logger.store = function(str) {
        Logger.storage.push(str);
        // Only call slice every 10 log calls to reduce garbage produced
        if (Logger.storage.length > 110) {
            Logger.storage = Logger.storage.slice(10)
        }
    };
    **/

    return Logger;
});

AJS.namespace('GH.Logger', null, require('jira-agile/rapid/logger'));
AJS.namespace('GH.log', null, require('jira-agile/rapid/logger').log);