define('jira-agile/rapid/layout', ["underscore", "jquery"], function(_, $) {
    const Layout = {};

    Layout.EVENT_DELAYED_RESIZE = 'delayedResize';

    Layout.info = {
        windowWidth: -1,
        windowHeight: -1
    };

    Layout.getWindowWidth = function() {
        return Layout.info.windowWidth;
    };

    Layout.getWindowHeight = function() {
        return Layout.info.windowHeight;
    };

    Layout.bindDelayedWindowResize = _.once(function() {
        $(window).bind('resize', _.debounce(function () {
            if (Layout.updateWindowSize()) {
                Layout.fireDelayedWindowResize();
            }
        }, 250));
    });

    /**
     * Updates the window size
     * @return boolean true if the size actually changed, false otherwise. IE8 fires resize event for css changes too :/
     */
    Layout.updateWindowSize = function() {
        var win = $(window);
        var oldWidth = Layout.info.windowWidth;
        var oldHeight = Layout.info.windowHeight;
        var newWidth = win.width();
        var newHeight = win.height();
        if (oldWidth === newWidth && oldHeight === newHeight) {
            return false;
        }

        // update sizes
        Layout.info.windowWidth = newWidth;
        Layout.info.windowHeight = newHeight;
        return true;
    };

    Layout.fireDelayedWindowResize = function() {
        $(GH).trigger(Layout.EVENT_DELAYED_RESIZE);
    };

    Layout.init = function() {
        Layout.updateWindowSize();
        Layout.bindDelayedWindowResize();
    };

    return Layout;
});

AJS.namespace('GH.Layout', null, require('jira-agile/rapid/layout'));