define("jira-agile/rapid/epics-data-service", ["jira/util/formatter", 'underscore'], function (Formatter, _) {
    "use strict";

    var _supportsPages = null;

    function EpicsDataService() {}

    EpicsDataService.prototype = {
        /**
         * Get the epics for the rapidViewId.
         *
         * @param {number} rapidViewId
         * @returns {Promise}
         */
        getEpics: function getEpics(rapidViewId) {
            return GH.Ajax.get({
                url: '/xboard/plan/backlog/epics.json',
                data: { rapidViewId: rapidViewId }
            }, 'epicsList').andThen(function (data) {
                _supportsPages = data.supportsPages;
                return data.epics;
            });
        },

        /**
         * Get simplified epics data for the rapidViewId.
         * The returned epics are in the form: { id: string, name: string }.
         * The epic label is prefixed with the epic key.
         *
         * @param {number} rapidViewId
         * @returns {Promise}
         */
        getSimpleEpics: function getSimpleEpics(rapidViewId) {
            return this.getEpics(rapidViewId).andThen(function (epics) {
                return _.map(epics, function (epic) {
                    return {
                        id: epic.key,
                        name: epic.epicLabel ? epic.key + ': ' + epic.epicLabel : Formatter.I18n.getText('gh.epic.label.unlabelled') + '-' + epic.key
                    };
                });
            });
        },

        /**
         * Convenience function to check if an epicKey is present in a list of epics.
         *
         * @param {Object[]} epics
         * @param {String} epicKey
         * @returns {boolean}
         */
        epicExists: function epicExists(epics, epicKey) {
            return _.some(epics, function (epic) {
                return epic.id === epicKey;
            });
        },
        supportsPages: function supportsPages() {
            if (_supportsPages === null) {
                throw 'epic data has not been loaded yet';
            } else {
                return _supportsPages;
            }
        }
    };

    return EpicsDataService;
});

AJS.namespace('GH.EpicsDataService', null, require('jira-agile/rapid/epics-data-service'));
AJS.namespace('GH.epicsDataService', null, new (require('jira-agile/rapid/epics-data-service'))());