/*!
 Copyright 2013 jQuery Foundation and other contributors,
 http://jqueryui.com/

 This software consists of voluntary contributions made by many
 individuals (AUTHORS.txt, http://jqueryui.com/about) For exact
 contribution history, see the revision history and logs, available
 at http://jquery-ui.googlecode.com/svn/

 Permission is hereby granted, free of charge, to any person obtaining
 a copy of this software and associated documentation files (the
 "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish,
 distribute, sublicense, and/or sell copies of the Software, and to
 permit persons to whom the Software is furnished to do so, subject to
 the following conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/**
 * bring back code removed from jquery ui:
 * isOverAxis, isOver: https://github.com/jquery/jquery-ui/commit/3ec0c2e5728da9b9b9955dfe18073d3985e61a52
 * hasScroll: https://github.com/jquery/jquery-ui/commit/ecd6a25a83b15d0c5af306c44befb9e652c82f37
 */
define('jira-agile/lib/jquery/inlined-code', ["jquery"], function ($) {
    "use strict";

    const isOverAxis = function (x, reference, size) {
        //Determines when x coordinate is over "b" element axis
        return (x > reference) && (x < (reference + size));
    };

    const isOver = function (y, x, top, left, height, width) {
        //Determines when x, y coordinates is over "b" element
        return isOverAxis(y, top, height) && isOverAxis(x, left, width);
    };

    const hasScroll = function (el, a) {
        //If overflow is hidden, the element might have extra content, but the user wants to hide it
        if ($(el).css("overflow") === "hidden") {
            return false;
        }
        var scroll = (a && a === "left") ? "scrollLeft" : "scrollTop",
            has = false;
        if (el[scroll] > 0) {
            return true;
        }
        // TODO: determine which cases actually cause this to happen
        // if the element doesn't have the scroll set, see if it's possible to
        // set the scroll
        el[scroll] = 1;
        has = (el[scroll] > 0);
        el[scroll] = 0;
        return has;
    };

    return {
        isOver: isOver,
        isOverAxis: isOverAxis,
        hasScroll: hasScroll
    };
});