
//Brought back from the future to use in GH before available via JIRA
//Taken from AJS with some modifications
//To be removed when AJS code available

(function () {
/**
 * This isn't yet in AUI, tracked in AJS-548
 *
 * @param uri
 * @param strict
 */
AJS.parseUri = function (uri, strict)
{
    function parseUri(str)
    {
        var o = parseUri.options,
                m = o.parser[o.strictMode ? "strict" : "loose"].exec(str),
                uri = {},
                i = 14;

        while (i--)
        {
            uri[o.key[i]] = m[i] || "";
        }

        uri[o.q.name] = {};
        uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2)
        {
            if ($1)
            {
                if(typeof uri[o.q.name][$1] === "object")
                {
                    uri[o.q.name][$1].push($2);
                }
                else if(uri[o.q.name][$1])
                {
                    uri[o.q.name][$1] = [uri[o.q.name][$1], $2];
                }
                else
                {
                    uri[o.q.name][$1] = $2;
                }
            }
        });

        return uri;
    }

    parseUri.options = {
        strictMode: !!strict,
        key: ["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],
        q:   {
            name:   "queryKey",
            parser: /(?:^|&)([^&=]*)=?([^&]*)/g
        },
        parser: {
            strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
            loose:  /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
        }
    };

    var hostname = AJS.$('<a>', {href: uri})[0].hostname;
    var isIpv6Address = hostname.indexOf(":") > -1; // Only IPv6 address contains ":" in the hostname
    var hasBrackets = hostname.indexOf("[") > -1 && hostname.indexOf("]") > -1;
    hostname = hasBrackets ? hostname : "[" + hostname + "]"; // Support for IE11
    var fakeHostname = "hostname";

    // temporarily change the IPv6 address to fake hostname
    if (isIpv6Address) {
        uri = uri.replace(hostname, fakeHostname);
    }

    uri = parseUri(uri);

    // revert to the origin IPv6 address
    if (isIpv6Address) {
        uri.host = hostname;
        uri.authority = uri.authority.replace(fakeHostname, uri.host);
        uri.source = uri.source.replace(fakeHostname, uri.host);
    }

    uri.toString = function () {
        var params = [];
        AJS.$.each(uri.queryKey, function (name, value) {
            if(_.isObject(value)) {
                AJS.$.each(value, function(index, innerVal) {
                    params.push(name + "=" + innerVal);
                });
            } else {
                params.push(name + "=" + value);
            }
        });
        return uri.protocol + "://" + uri.authority + uri.path + "?" + params.join("&") + "#" + uri.anchor;
    };

    return uri;
};
})();