define('jira-agile/gh-globalissueoperations', ["jira/dialog/form-dialog", "jira/dialog/dialog-register", "jquery"], function (FormDialog, Dialogs, $) {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    var analytics = new AnalyticsTracker('gh.issueaction.gotorapidboard').setAsync(false);

    var GoToBoardDialog = FormDialog.extend({
        /**
         * Default implementation replaces the current URL, but we want to instead change the URL so that browser
         * history is kept in tact.
         */
        _performRedirect: function _performRedirect(url) {
            // fire analytics for directly going through to a board
            // NOTE: missing eventSuffix here because it would be annoying to determine at this time
            analytics.trigger('direct'); // SAFE

            window.location.href = url;
        }
    });

    var dialog = new GoToBoardDialog({
        id: "gh-rapidboard-dialog",
        trigger: ".issueaction-greenhopper-rapidboard-operation",
        ajaxOptions: function ajaxOptions() {
            // JIRA.Dialogs.getDefaultAjaxOptions is overwritten in JIRA 6.2, we use this indirect call
            // to avoid calling the wrong getDefaultAjaxOptions() method due web-resource loading order
            return Dialogs.getDefaultAjaxOptions.apply(this, arguments);
        }
    });

    var eventActionResolver = function eventActionResolver(link, action) {
        var eventSuffix = '';
        var $link = $(link);
        if ($link.hasClass('js-rapidboard-operation-sprint')) {
            eventSuffix = 'sprint.';
        } else if ($link.hasClass('js-rapidboard-operation-issue')) {
            eventSuffix = 'issue.';
        }
        eventSuffix += action;
        return eventSuffix;
    };

    return {
        init: function init() {
            $(document).on('simpleClick', '.issueaction-greenhopper-rapidboard-operation', function (event) {
                event.preventDefault();
                var eventAction = eventActionResolver(event.currentTarget, 'open');

                // fire analytics event for initiating the action
                analytics.trigger(eventAction); // SAFE

                dialog.show();
            });

            // listen for event when choosing a board
            $(document).on('simpleClick', '.js-select-rapidboard', function (event) {
                var eventAction = eventActionResolver(event.currentTarget, 'chosen');

                // fire analytics event for initiating the action
                analytics.trigger(eventAction); // SAFE
            });
        }
    };
});

require('jira-agile/gh-globalissueoperations').init();