AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common","com.pyxis.greenhopper.jira:gh-rapid" ], function() {
    var jquery = require("jquery");
    var _ = require("underscore");

    module("gh-IssueActionsDialog-fetchConfiguration", {
        setup: function() {
            this.context = AJS.test.mockableModuleContext();
            var onSpy = sinon.spy();
            var offSpy = sinon.spy();
            this.onSpy = onSpy;
            this.offSpy = offSpy;
            this.QueryableDropdownSelect = function () {};
            this.context.mock('jira/ajs/select/queryable-dropdown-select', this.QueryableDropdownSelect);

            this.mockedJquery = function () {
                var ret = jquery.apply(arguments);
                ret.on = onSpy;
                ret.off = offSpy;
                return ret;
            };
            _.extend(this.mockedJquery, jquery);
            this.context.mock('jquery', this.mockedJquery);
            this.IssueActionsDialog = this.context.require("jira-agile/dialog/issue-actions");
        },
        teardown: function() {
        }
    });

    test("Setting content should remove and add listeners", function() {
        var dialog = new this.IssueActionsDialog();

        dialog.show();

        var onCalls = this.onSpy.getCalls().filter(function (c) {return c.args.length>0 && c.args[0]==='click.ghIssueActionListeners'});
        var offCalls = this.offSpy.getCalls().filter(function (c) {return c.args.length>0 && c.args[0]==='click.ghIssueActionListeners'});
        equal(onCalls.length, 1, "Listener should be added once");
        equal(onCalls[0].args[1], '#issueactions-suggestions .unified-attach-file');
        equal(offCalls.length, 1), "Listener should be removed once";
        ok(onCalls[0].callId > offCalls[0].callId, "Listener should be added after listener removal")
    });

    test("Hiding should remove listeners", function() {
        var dialog = new this.IssueActionsDialog();

        dialog.show();

        this.onSpy.reset();
        this.offSpy.reset();
        dialog.hide();
        var onCalls = this.onSpy.getCalls().filter(function (c) {return c.args.length>0 && c.args[0]==='click.ghIssueActionListeners'});
        var offCalls = this.offSpy.getCalls().filter(function (c) {return c.args.length>0 && c.args[0]==='click.ghIssueActionListeners'});
        equal(onCalls.length, 0);
        equal(offCalls.length, 1);
    });
});