define('jira-agile/dialog/init-dialogs', ['jquery', 'require'], function (jQuery, require) {
    var domReadyPromise = function () {
        var deferred = jQuery.Deferred();
        jQuery(function () {
            deferred.resolve();
        });
        return deferred.promise();
    }();

    var waitFor = [domReadyPromise];

    jQuery.when.apply(null, waitFor).done(function () {
        require(['jira/dialog/dialog-register', 'jira-agile/dialog/issue-actions', 'jira-agile/dialog/labels-dialog', 'jira/dialog/screenshot-window', 'jira/dialog/form-dialog', 'jira/dialog/dialog'], function (dialogRegister, IssueActionsDialog, LabelsDialog, ScreenshotDialog, FormDialog, Dialog) {
            var IssueNavigator = JIRA.IssueNavigator;
            var Issue = JIRA.Issue;

            // Since now we're reusing Full page issue view components on ADV,
            // so that we don't need to unload all dialogs from JIRA.
            var JIRA_DIALOG_WHITELIST = ['deleteIssueLink', 'editComment', 'deleteComment'];

            /* dialogs.js runs first, which will already initializes dialogRegister
             * as part of the initialization setTransitions is called, so we end up having the in-page link urls hooked up to
             * the trigger events already.
             * Make sure we clear out the attached click handlers before adding our own ones
             */
            // unload all the dialogs
            var value;
            for (var name in dialogRegister) {
                if (dialogRegister.hasOwnProperty(name)) {
                    if (JIRA_DIALOG_WHITELIST.indexOf(name) >= 0) {
                        continue;
                    }
                    value = dialogRegister[name];
                    if (value._unassignEvents && value.options.trigger) {
                        // unassign the live events previously assigned by each dialog
                        value._unassignEvents("trigger", value.options.trigger);
                    }
                }
            }

            // unassign the workflow dialog creation function
            jQuery(document).undelegate(".issueaction-workflow-transition", "click");

            // remove the attach screenshot live handler
            jQuery(".issueaction-attach-screenshot").die("click");

            dialogRegister.keyboardShortcuts = new FormDialog({
                id: "keyboard-shortcuts-dialog",
                trigger: "#keyshortscuthelp",
                widthClass: "large",
                onContentRefresh: function onContentRefresh() {
                    var context = this.get$popupContent();
                    jQuery("a.submit-link", context).click(function (e) {
                        e.preventDefault();
                        jQuery("form", context).submit();
                    });
                }
            });

            if (document.getElementById("dashboard")) {

                dialogRegister.deleteDashboard = new FormDialog({
                    type: "ajax"
                });

                jQuery(document).delegate("#delete_dashboard", "click", function (e) {
                    e.stopPropagation();
                    e.preventDefault();

                    dialogRegister.deleteDashboard.$activeTrigger = jQuery("#delete_dashboard");
                    dialogRegister.deleteDashboard.init({
                        type: "ajax",
                        id: "delete-dshboard",
                        ajaxOptions: {
                            url: dialogRegister.deleteDashboard.$activeTrigger.attr("href")
                        },
                        targetUrl: "input[name=targetUrl]"
                    });
                    dialogRegister.deleteDashboard.show();
                });
            } else {
                dialogRegister.assignToMe = new GH.FormDialog({
                    id: "assign-to-me-link-handler",
                    trigger: ".issueaction-assign-to-me",
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_assigned'
                });

                // Issue-related dialogs should not be active on the dashboard.

                dialogRegister.linkIssue = GH.LinkIssueDialog.create(".issueaction-link-issue");

                dialogRegister.deleteIssue = new GH.FormDialog({
                    id: "delete-issue-dialog",
                    trigger: ".issueaction-delete-issue",
                    targetUrl: "#delete-issue-return-url",
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_deleted',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.archiveIssue = new GH.FormDialog({
                    id: "archive-issue-dialog",
                    trigger: ".issueaction-archive-issue",
                    targetUrl: "#archive-issue-return-url",
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_archived',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.cloneIssue = new GH.FormDialog({
                    id: "clone-issue-dialog",
                    trigger: ".issueaction-clone-issue",
                    handleRedirect: true,
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_cloned',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.assignIssue = new GH.FormDialog({
                    id: "assign-dialog",
                    trigger: ".issueaction-assign-issue",
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_assigned',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.logWork = new GH.FormDialog({
                    id: "log-work-dialog",
                    trigger: ".issueaction-log-work",
                    handleRedirect: true,
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_worklogged',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                        var context = this.get$popupContent();
                    }
                });

                dialogRegister.attachFile = new GH.FormDialog({
                    id: "attach-file-dialog",
                    trigger: ".issueaction-attach-file",
                    handleRedirect: true,
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_attached',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.attachScreenshotDialog = new GH.FormDialog({
                    id: "attach-screenshot-dialog",
                    trigger: ".issueaction-attach-screenshot-html5",
                    handleRedirect: true,
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_attached',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.attachScreenshot = new ScreenshotDialog({
                    id: "attach-screenshot-window",
                    trigger: ".issueaction-attach-screenshot"
                });

                dialogRegister.comment = new GH.FormDialog({
                    id: "comment-add-dialog",
                    // the rapid board displays the operations bar as well (thus uses the ops class), but in our case we want a popup, not an inline edit (as in the view issue page)
                    // trigger: ":not(.ops) > * > a.issueaction-comment-issue",
                    trigger: ".issueaction-comment-issue",
                    handleRedirect: true,
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_commented',
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.editLabels = new LabelsDialog({
                    id: "edit-labels-dialog",
                    trigger: ".issueaction-edit-labels,a.edit-labels",
                    autoClose: true,
                    ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                    onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                    issueMsg: 'thanks_issue_labelled',
                    labelsProvider: labelsProvider,
                    onContentRefresh: function onContentRefresh() {
                        jQuery(".overflow-ellipsis").textOverflow();
                    }
                });

                dialogRegister.issueActions = new IssueActionsDialog();

                /** Preserve legacy namespace
                 @deprecated jira.app.issueActionsPopup */
                AJS.namespace("jira.app.issueActionsPopup", null, dialogRegister.issueActions);

                // Workflow transition dialogs
                jQuery(document).delegate(".issueaction-workflow-transition", "click", function (event) {
                    event.preventDefault();
                    var action = /action=(\d+)/.exec(this.href.slice(this.href.indexOf("?")));
                    if (action) {
                        var id = "workflow-transition-" + action[1] + "-dialog";
                        var $trigger = jQuery(this);
                        if (!dialogRegister[id]) {
                            dialogRegister[id] = new GH.FormDialog({
                                id: id,
                                url: $trigger.attr("href"),
                                // GreenHopper: this id is read just before the dialog is displayed and used to fetch the resolutions that should be active
                                transitionActionId: action[1],
                                trigger: 'a[href*="' + action[0] + '"].issueaction-workflow-transition',
                                widthClass: "large",
                                handleRedirect: true,
                                ajaxOptions: dialogRegister.getDefaultAjaxOptions,
                                onSuccessfulSubmit: dialogRegister.storeCurrentIssueIdOnSucessfulSubmit,
                                issueMsg: 'thanks_issue_transitioned',
                                onContentRefresh: function onContentRefresh() {
                                    // initialise AJS tabs for the workflow dialogs
                                    AJS.tabs.setup();
                                }
                            });
                            dialogRegister[id].show();
                        }
                    }
                });

                // Dialogs should only show up if there's an issue to work on!
                jQuery.each(dialogRegister, function (name, dialog) {
                    if (dialog instanceof Dialog) {
                        jQuery(dialog).bind("beforeShow", function () {
                            // For all issue-related dialogs, check if we have a valid issue to work on!
                            if (name !== "keyboardShortcuts") {
                                return IssueNavigator.isRowSelected() || Issue.getIssueId() !== undefined;
                            }
                        });
                    }
                });
            }

            function labelsProvider(labelsPopup) {}
        });
    });
});
require('jira-agile/dialog/init-dialogs');