GADGET = {};

GADGET.boardInitialized = false;

GADGET.preInit = function(baseUrl) {
    // gadgets have a slightly different lifecycle/context because they're loaded in an iframe.
    // given that, we need to explicitly trigger the initialisation event when they load.
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

	// redefine the context path
	GH.Ajax.CONTEXT_PATH = baseUrl;
};

GADGET.isWallboardMode = function() {
    return GH.gadget.utils.getViewName() == 'wallboard';
};

/**
 * Ajax requests for the template
 */
GADGET.templateArgs = function(baseUrl) {
    //Assign wallboard class here so errors also get this class in the body
    if (GADGET.isWallboardMode()) {
        AJS.$('body').addClass('wallboard');
    }
    return [];
};

/**
 * Gadget template function
 */
GADGET.template = function (gadget, args, baseUrl) {
	if (!GADGET.boardInitialized) {
		// initialize the actual rendering code
		GH.RapidBoard.initRapidViewGadget(gadget);
		GADGET.boardInitialized = true;
	}

	// render the rapid view
	GH.RapidBoard.loadAndRenderRapidViewGadget(gadget);
};

/**
 * Ajax requests to be executed for the descriptor
 */
GADGET.descriptorArgs = function(baseUrl) {
    return [
        {
            key: "rapidViews",
            ajaxOptions:  baseUrl + "/rest/greenhopper/1.0/rapidview"
        }
    ];
};

/**
 * Gadget descriptor
 */
GADGET.descriptor = function (gadget, args, baseUrl) {
	//[GHS-2677]
	//Root cause is that the existing content is not cleared when an error is added as a result of a gadget refresh
	//To fix this we hide existing content when this class is appended into the body
	//Calling descriptor should remove class indicating invalidness
	AJS.$("body").removeClass('config-unavailable');

    return  {
        action: baseUrl + "/rest/greenhopper/1.0/gadgets/rapidview/pool/validate.json",
        theme : function()
        {
            if (gadgets.window.getViewportDimensions().width < 450)
            {
                return "gdt top-label";
            }
            else
            {
                return "gdt";
            }
        }(),
        fields: [
            GH.gadget.rapid.fields.rapidViewPicker(gadget, "rapidViewId", args.rapidViews.views),
            GH.gadget.fields.checkbox(gadget, "showRapidViewName", 'gh.gadget.userpref.showrvname.name', gadget.getPref('showRapidViewName') == 'true'),
            GH.gadget.rapid.fields.quickFilterPicker(gadget, "quickFilters", 'rapidViewId'),
            GH.gadget.fields.checkbox(gadget, "showQuickFilterNames", 'gh.gadget.userpref.showqfname.name', gadget.getPref('showQuickFilterNames') == 'true'),
            AJS.gadget.fields.nowConfigured()
        ]
    };

};

// RapidViewGadget

/**
 * Initializes the rapid view gadget.
 */
GH.RapidBoard.initRapidViewGadget = function(gadget) {
    // prevent default error handling (non closable messages) inherited from common gadget library
    gadget.ajaxErrorHandler.handle404 = AJS.$.noop;
    // prevent default error handling when loading rapid view configuration
    GH.RapidViewConfig.handleRapidLoadError = AJS.$.noop;

    // render the base html into the view
    gadget.getView().html('<div id="gh" class="ghx-gh"></div>');
    AJS.$('#gh').html(GH.tpl.board.x.renderRapidBoard());

    // SwimlaneView
    GH.SwimlaneView.init();

    // Work controls
    GH.WorkControls.init();

    // Work Selection Controller
    GH.WorkSelectionController.initSelectionManager();
};

GH.RapidBoard.loadAndRenderRapidViewGadget = function(gadget) {

    var callback = function(data) {
        GH.RapidBoard.renderRapidViewGadget(gadget, data);
    };

    // make sure the work data loader always loads new data
    GH.WorkDataLoader.markDirty();

    var rapidViewId = parseInt(gadget.getPref("rapidViewId"), 10);
    GH.RapidViewConfig.fetchConfiguration(rapidViewId).done(callback).fail(function () {
        GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.common.error.can.not.find.board.or.nopermission'));
    });

    GH.RapidBoard.ViewController.preload(rapidViewId);
};

/**
 * This function sets the correct configuration, then forces a reload
 */
GH.RapidBoard.renderRapidViewGadget = function(gadget, rapidViewConfig) {
    // initialize the controller with the right view
    GH.WorkController.setRapidView(rapidViewConfig);

    // set the quickfilters
    // TODO: interact directly with WorkControls
    var quickFilters = gadget.getPref('quickFilters').split('|');
    quickFilters = _.without(quickFilters, 'none');
    quickFilters = _.without(quickFilters, '');
    GH.WorkControls.setActiveQuickFilterIds(quickFilters);

    // resize the gadget
    AJS.$(GH).bind('workModeUIReady', function() {
        gadget.resize();
    });

    AJS.$('#ghx-work').show();

    GH.WorkController.show().always(function () {
        // always handle the empty state message even if error occur
        GH.WorkController.handleEmptyMessageInDashboard();
    });

    // set title
    GH.RapidBoard.setRapidViewGadgetTitle(rapidViewConfig, gadget.getPref('showRapidViewName') == 'true', quickFilters, gadget.getPref('showQuickFilterNames') == 'true');
};

/**
 * Set the gadget title to include the name of the Rapid View which is selected
 * @param rapidViewId selected rapid view
 */
GH.RapidBoard.setRapidViewGadgetTitle = function(rapidViewConfig, showViewName, quickFilterIds, showQuickFilterNames) {

    // clean out the previous title
    AJS.$('h2.gg-name').remove();

    // if we're showing either name,render the header
    if (showViewName || showQuickFilterNames) {

        // adds title to gadget header
        // gadgets.window.setTitle(AJS.I18n.getText("gh.gadget.rapid.view.title.specific", theView.name));
        // clean out any previous headings


        GH.RapidBoard.constructAndInsertGadgetHeader(rapidViewConfig, showViewName, quickFilterIds, showQuickFilterNames);

    }
};

GH.RapidBoard.constructAndInsertGadgetHeader = function(rapidViewConfig, showViewName, quickFilterIds, showQuickFilterNames) {

    var $title = AJS.$('<h2 class="gg-name"></h2>');// name of board
    var $filtered = AJS.$('<span></span>');// span with filter names
    var $place = AJS.$('#ghx-pool');// place to put all of previous

    if (showViewName) {
        $title.text(rapidViewConfig.name);
    }

    // if we're showing quick filter names, then gather those, put them into the html and paste that into the dom
    // otherwise just put the title into the dom now
    if (showQuickFilterNames && quickFilterIds.length > 0) {
        // JRASERVER-65935 - fix for xss and code cleaning - pls go functional
        var selectedFiltersString = _.chain(rapidViewConfig.quickFilters)
            .filter(function (quickFilter) {
                return _.contains(quickFilterIds, quickFilter.id)
            })
            .map(function (quickFilter) {
                return AJS.escapeHTML(quickFilter.name);
            })
            .value()
            .join(", ");
        // put the namestring into a span inside the title
        $filtered.append("(" + selectedFiltersString + ")").appendTo($title);
    }
    // place into gadget
    $place.before($title);
};