(function ($) {

    function createEpicPicker(ctx) {
        $(".js-epic-picker", ctx).each(function () {
            var $this = $(this);
            var control = new JIRA.EpicPicker({
                element: $this
            });
            $(document).trigger(JIRA.EpicPicker.READY_EVENT, control);
        });
    }

    function createSprintPicker(ctx) {
        $(".js-sprint-picker", ctx).each(function () {
            var $this = $(this);
            var control = new JIRA.SprintPicker({
                element: $this
            });
            $(document).trigger(JIRA.SprintPicker.READY_EVENT, control);
        });
    }

    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context, reason) {
        if (reason !== JIRA.CONTENT_ADDED_REASON.panelRefreshed) {
            createEpicPicker(context);
            createSprintPicker(context);
        }
    });
})(AJS.$);