define('includes/js/field/sprint-suggest-handler',
   [ 'jira/ajs/select/suggestions/checkbox-multi-select-suggest-handler'],
    function(CheckboxMultiselectSuggestHandler) {

        var prepareSelectedDescriptors = function (selectedDescriptors) {
            _.each(selectedDescriptors, function(selectedDescriptor) {
                var metaData = JSON.parse(selectedDescriptor.properties.meta);
                metaData.date = moment(metaData.date).format('LL');
                selectedDescriptor.properties.title = GH.tpl.customfields.sprintmultiselect.renderTooltip(metaData);
                selectedDescriptor.properties.html = GH.tpl.customfields.sprintmultiselect.renderSuggestionMeta(metaData);
            });
        }

    return CheckboxMultiselectSuggestHandler.extend({


        formatSuggestions: function (descriptors, query) {

            var selectedDescriptors = this.model.getDisplayableSelectedDescriptors();
            prepareSelectedDescriptors(selectedDescriptors);

            var isNotInSelectedItems = function(item) {
                var selectedDescriptor;
                for (selectedDescriptor in selectedDescriptors) {
                    if (selectedDescriptors[selectedDescriptor].properties.value === item.properties.value.toString()) {
                        return false;
                    }
                }
                return true;
            };

            descriptors = _.map(descriptors, function(descriptor) {
                var items = _.filter(descriptor.properties.items, isNotInSelectedItems);
                descriptor.properties.items = items;
                return descriptor;
            });
            return this._super(descriptors, query);

        }
    });

});

AJS.namespace('GH.SprintSuggestHandler', null, require('includes/js/field/sprint-suggest-handler'));
