JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, $ctx) {

    function _formatSprintResponse(response) {

        var suggestionGroupDescriptor = new AJS.GroupDescriptor({
            weight: 0,
            label: AJS.I18n.getText('gh.sprint.customfield.dropdown.suggestions'),
            items: _.map(response.suggestions, getItemDescriptorForSprint)
        });

        var allMatchesGroupDescriptor = new AJS.GroupDescriptor({
            weight: 1,
            label: AJS.I18n.getText('gh.sprint.customfield.dropdown.all'),
            items: _.map(response.allMatches, getItemDescriptorForSprint)
        });

        return [suggestionGroupDescriptor, allMatchesGroupDescriptor];
    }

    function getItemDescriptorForSprint(sprint) {

        sprint.date = moment(sprint.date, 'YYYY-MM-DDTHH:mm:ssZ').format('LL');
        var html = GH.tpl.customfields.sprintmultiselect.renderSuggestionMeta(sprint);

        return new AJS.ItemDescriptor({
            value: sprint.id,
            label: sprint.name,
            html: html,
            title: GH.tpl.customfields.sprintmultiselect.renderTooltip(sprint),
            date: sprint.date,
            boardName: sprint.boardName,
            stateKey: sprint.stateKey,
            highlighted: true,
            allowDuplicate: false
        });
    }

    function sortSprintsById(sprints) {
        return _.sortBy(sprints, "id");
    }

    AJS.$(".js-sprint-checkboxmultiselect", $ctx).each(function () {
        var multiSelect = new AJS.CheckboxMultiSelect({
            element: this,
            maxInlineResultsDisplayed: 5,
            content: "ajax",
            removeOnUnSelect: true,
            ajaxOptions: {
                url: AJS.contextPath() + "/rest/greenhopper/1.0/sprint/picker",
                error: function error() {
                    multiSelect._setSuggestions([]);
                },
                data: {
                    excludeCompleted: false
                },
                query: true,
                formatResponse: _formatSprintResponse
            },
            suggestionsHandler: GH.SprintSuggestHandler
        });
    });
});