AJS.test.require([
    "com.pyxis.greenhopper.jira:gh-test-common",
    "com.pyxis.greenhopper.jira:gh-rapid-config",
    "com.pyxis.greenhopper.jira:gh-admin-lexorank-manage-app"
], function () {
    const $ = require('jquery');

    const LexoRankManagementModel = require('jira-agile/admin/lexorank/lexorank-management-model');
    const LexoRankManagementService = require('jira-agile/admin/lexorank/services/lexorank-management-service');
    const LexoRankManagementView = require('jira-agile/admin/lexorank/views/lexorank-management-view');

    let model;
    let service;
    let view;

    module("LexoRank Management tests", {
        setup: function () {
            GH.Test.setUpFakeServer(this);
            GH.Test.respondToGetWith200(this, "/lexorank/balance", {
                "lexoRankBalancingServiceStatus": {
                    "balancingDisabled": false,
                    "balanceHandlerRunning": false
                },
                "lexoRankBalancerStatus": {
                    "balancerLocked": false,
                    "perFieldStatus": [
                        {
                            "fieldName": "Rank",
                            "fieldId": 10400,
                            "numRankedIssues": 4428,
                            "percentComplete": 100,
                            "distribution": [
                                4428,
                                0,
                                0
                            ],
                            "maxRank": {
                                "issueId": 10100,
                                "issueKey": "TEST-1",
                                "rankLength": 9,
                                "maxLength": 254,
                                "nextRebalance": {
                                    "isImmediate": false,
                                    "isRankOperationDisabled": false,
                                    "limit": 50,
                                    "status": "OK"
                                }
                            }
                        }
                    ]
                }
            });
            this.clock = sinon.useFakeTimers();
            model = new LexoRankManagementModel();
            service = new LexoRankManagementService(model);
            view = new LexoRankManagementView({
                el: "#qunit-fixture",
                model,
                service
            });
            this.clock.tick(100);
        },
        teardown: function () {
            this.clock.restore();
            GH.Test.restoreServer(this);
        },
        getQunitFixture: function () {
            return AJS.$("#qunit-fixture");
        }

    });

    test("Initialisation", function () {
        // initially the balancing status is empty
        strictEqual($("#js-lrmng-balance-status").children().length, 0, "0 children rendered");

        // after server responds we expect some elements
        this.server.respond();

        this.clock.tick(100);

        strictEqual($("#js-lrmng-balance-status").children().length, 2, "2 child tables rendered");

        // the refresh button should be enabled
        var refreshButton = $(".js-lrmng-balance-refresh-button");
        strictEqual(refreshButton.attr("aria-disabled"), undefined, 'Refresh button is enabled');

    });

    test("Balance refresh", function () {
        // server responds to initial refresh, we expect some elements
        this.server.respond();

        this.clock.tick(100);

        strictEqual($("#js-lrmng-balance-status").children().length, 2, "2 children rendered");

        // the refresh button should be enabled
        var refreshButton = $(".js-lrmng-balance-refresh-button");
        strictEqual(refreshButton.attr("aria-disabled"), undefined, 'Refresh button is enabled');

        // click the refresh button
        refreshButton.click();

        this.clock.tick(100);

        // now refresh button should be disabled
        strictEqual(refreshButton.attr("aria-disabled"), "true", 'Refresh button is disabled');

        // server responds
        this.server.respond();

        this.clock.tick(100);

        // the refresh button should be ENABLED
        strictEqual(refreshButton.attr("aria-disabled"), undefined, 'Refresh button is enabled');

    });


    test("Integrity checks", function () {
        GH.Test.respondToGetWith200(this, "/lexorank/integrity", {
            "reports": [
                {
                    "rankFieldId": 10400,
                    "rankFieldName": "Rank",
                    "results": [
                        {
                            "name": "Marker rows present in table for rank field",
                            "description": "Checks if the rank table has been properly initialized for the rank field. A minimum and maximum marker row are expected to be present in the table for the rank field.",
                            "passed": true,
                            "fatal": true
                        }
                    ]
                }
            ]
        });
        model = new LexoRankManagementModel();
        service = new LexoRankManagementService(model);
        view = new LexoRankManagementView({
            el: "#qunit-fixture",
            model,
            service
        });

        this.clock.tick(100);

        // one child element in integrity results
        strictEqual($("#js-lrmng-integrity-check").children().length, 1, "1 children rendered");
        this.server.respond();

        this.clock.tick(100);

        // after initial server response, still only one child element in integrity results
        strictEqual($("#js-lrmng-integrity-check").children().length, 1, "1 children rendered");

        // initially run button is enabled
        let runButton = $(".js-lrmng-integrity-run-button");
        strictEqual(runButton.attr("aria-disabled"), undefined, 'Run button is enabled');

        // click the run button
        runButton.click();

        this.clock.tick(100);

        // run button is now disabled
        runButton = $(".js-lrmng-integrity-run-button");
        strictEqual(runButton.attr("aria-disabled"), "true", 'Run button is disabled');

        // server responds
        this.server.respond();

        this.clock.tick(100);

        // run button enabled again
        runButton = $(".js-lrmng-integrity-run-button");
        strictEqual(runButton.attr("disabled"), undefined, 'Run button is enabled');

        // after integrity check response, still only one child element in integrity results
        strictEqual($("#js-lrmng-integrity-check").children().length, 1, "1 child rendered");

    });

    test("Rank status help link is rendered", function() {
        this.server.respond();
        this.clock.tick(100);

        const helpLink = $(".gh-lrmng-rank-status-help-link a");

        // Help links are not converted to the i18n key when running QUnit tests. Therefore, we validate that the URL starts with docs.atlassian.com
        // It's not great - but better than asserting the i18n value which is (more) susceptible to change.
        strictEqual(helpLink.attr('href').substr(0, 42), "https://docs.atlassian.com/jira/jadm-docs-", "Help link is rendered");
    });

    test("Rank status is rendered", function() {
        this.server.respond();
        this.clock.tick(100);

        const fieldId = 10400;
        const fieldRow = $("#gh-lrmng-balance-dbstatus-field-" + fieldId);

        strictEqual(fieldRow.find('.gh-lrmng-rebalance-status').text(), "OK", "Status is rendered");
        strictEqual(fieldRow.find('.gh-lrmng-rebalance-rank-length').text(), "9 / 254", "Rank length is rendered");
        strictEqual(fieldRow.find('.gh-lrmng-rebalance-next').text(), "gh.configuration.lexorank-manage.balance.dbstatus.rank.status.nextrebalance.scheduled", "Next rebalance is rendered");
        strictEqual(fieldRow.find('.gh-lrmng-rebalance-issue-key').text(), "TEST-1", "Highest ranked issue is rendered");
    });
});
