/**
 * Simple JS for toggling Labs features
 */
define('jira-agile/admin/labs/labs-configuration', [
    'jquery'
], function($) {
    'use strict';

    var setLabsFeature = function (featureId, newValue) {
        var xsrfToken = $('#atlassian-token').attr('content');
        var url = AJS.contextPath() + "/secure/SetLabs.jspa";

        return $.ajax({
            url: url,
            type: 'POST',
            data: {
                'featureId': featureId,
                'newValue': newValue,
                'atl_token': xsrfToken
            }
        });
    };

    var showDisableConfirmationDialog = function (featureName, message, onDialogConfirm, onCancelDialog) {
        var dialog = GH.Dialog.create({
            width: 500,
            height: 220,
            id: "ghx-disable-lab-feature-confirmation",
            closeOnOutsideClick: false
        });

        dialog.addHeader(AJS.format(AJS.I18n.getText('gh.configuration.labs.disable.confirm.dialog.header'), featureName));

        dialog.addPanel("Panel 1", "<p>" + message + "</p>", "panel-body");

        dialog.addButton(AJS.I18n.getText('gh.rapid.operations.confirm'),
            function () {
                if (onDialogConfirm && typeof onDialogConfirm === "function") {
                    onDialogConfirm();
                }

                dialog.disableControls();
                dialog.dispose();
            }, 'aui-button aui-button-primary'
        );

        dialog.addCancel(AJS.I18n.getText('gh.rapid.operations.cancel'), function () {
            if (onCancelDialog && typeof onCancelDialog === "function") {
                onCancelDialog();
            }
            dialog.cancel(dialog);
        });

        AJS.$('#' + dialog.id).addClass('ghx-dialog');
        dialog.show();
    };

    var onToggleLabsFeatureCheckbox = function () {
        var checkbox = this;
        var $checkboxContainerWrap = $(checkbox).closest('div.checkbox');
        var disableConfirmMessage = $checkboxContainerWrap.attr('data-confirm-disable-message');
        var featureName = $checkboxContainerWrap.find('label').text().trim();

        if (!checkbox.checked && disableConfirmMessage) {
            showDisableConfirmationDialog(featureName, disableConfirmMessage,
                function () {
                    setLabsFeature(checkbox.id, checkbox.checked);
                },
                function () {
                    checkbox.checked = !checkbox.checked;
                });
        }
        else {
            setLabsFeature(checkbox.id, checkbox.checked);
        }
    };

    return {
        setLabsFeature: setLabsFeature,
        onToggleLabsFeatureCheckbox: onToggleLabsFeatureCheckbox
    };
});

(function(AJS, $) {
    var initialiseEvents = function() {
        var LabsConfiguration = require('jira-agile/admin/labs/labs-configuration');
        $('.js-labs-feature input').on('click', LabsConfiguration.onToggleLabsFeatureCheckbox);
    };

    $(initialiseEvents);
})(AJS, AJS.$);
