define("jira-dashboard-items/sprint-health-view", [
    'jquery',
    'underscore'
], function($, _) {

    // Refresh interval (minutes)
    var GADGET_REFRESH_INTERVAL = 15;

    function SprintHealthView(dashboardItemID){

        this.id = dashboardItemID;

    }

    SprintHealthView.prototype = {

        templates: GH.tpl.dashboardItems.sprintHealth,

        setElement: function(element){
            this.element = element;
        },
        /*
        * Render the configuration screen for the dashboard item
        * @param {Node}
        * @param {Object} requiredParams
        */
        renderConfigView: function (element, requiredParams) {

            element.html(this.templates.configuration(requiredParams));

            var form = $("form", element);
            var formCancel = $("input.cancel", form);

            var boardPicker = form.find("select[name=board-type]");

            this.boardPicker = boardPicker;
            this.prefix = requiredParams.prefix;

            form.on("submit", this.onSubmit.bind(this));
            formCancel.on("click", this.onCancel.bind(this));

            //  Events being listened to by controller
            this.boardPicker.bind("change", this.onBoardPickerChange.bind(this));

            //  To initially populate the sprintPicker
            this.boardPicker.trigger("change");

            AJS.$(this).trigger("refreshLayout");

        },

        /*
         * Render the  screen for the dashboard item
         * @param {Node} element
         * @param {Object} requiredParams
         */
        renderDashboardItem: function (element, requiredParams) {

            element.html(this.templates.render(requiredParams));

            AJS.$(this).trigger("refreshLayout");

            this.initializeDialogs(element, requiredParams.progress);

        },

        /*
         * Render all inline dialogs
         * @param {Node} element
         * @param {Object} progress
         */
        initializeDialogs : function(element, progress){

            var currDialog = element.find(".inlineToDoDialog");
            var prefix = this.prefix;

            this.renderInlineDialog(currDialog, prefix + "todo-dialog", AJS.I18n.getText("gh.gadget.issues.to.do"),
                progress.todoMetric, progress.todoPercentage);

            currDialog = element.find(".inlineProgressDialog");
            this.renderInlineDialog(currDialog, prefix + "progress-dialog", AJS.I18n.getText("gh.gadget.issues.in.progress"),
                progress.inprogressMetric, progress.inprogressPercentage);

            currDialog = element.find(".inlineDoneDialog");
            this.renderInlineDialog(currDialog, prefix + "done-dialog", AJS.I18n.getText("gh.gadget.issues.completed"),
                progress.doneMetric, progress.donePercentage);

        },

        /*
         * Populates all inline dialogs with their required content
         * @param {Node} element
         * @param {Node} dialogIdentifier
         * @param {String} heading
         * @param {Integer} metric
         * @param {Integer} percentage
         */
        renderInlineDialog : function(element, dialogIdentifier, heading, metric, percentage){

            //  The HTML to be applied (acquired from Soy template .SimpleInlineDialog({params}))
            var contents = this.templates.simpleInlineDialog({
                heading: heading,
                metric: metric,
                percentage: percentage,
                link: element.attr("href")
            });

            AJS.InlineDialog(element, dialogIdentifier,
                function(content, trigger, showPopup) {
                    content.addClass("sprint-health-dashboard-item-dialog-decorator").html(contents);
                    showPopup();
                    return false;
                },
                {
                    hideDelay: 1000,
                    closeOnTriggerClick: true
                }
            );

        },

        showNoBoardsAvailableErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('gh.rapid.no.views'));
        },

        showRapidViewCannotBeFoundErrorMessage: function() {
            this._showErrorMessage( AJS.I18n.getText('gh.rapid.view.error.noview'));
        },

        showGadgetNotAllowedToRenderErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('error.gadget.gone'));
        },

        showSprintNotActiveErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('gh.gadget.sprint.error.selected.sprint.not.active'));
        },

        _showErrorMessage : function(message){
            this.element.html(this.templates.errorRenderingConfiguration({
                message: message
            }));

            AJS.$(this).trigger('refreshLayout');

        },

        renderCurrentSprints : function(newSprintList){

            var element = this.element;
            var $sprintList = element.find("form select[name=sprint-type]");

            $sprintList.empty();
            $sprintList.append(this.templates.getOption({
                auto : true
            }));

            _.each(newSprintList, function(sprintElem){
                $sprintList.append(this.templates.getOption({
                    text:   sprintElem.name,
                    value:  sprintElem.id
                }));
            }, this);
        },

        onSubmit: function(evt){

            evt.preventDefault();

            var form = $(evt.currentTarget);

            var isConfigured        = true,
                rapidViewId         = form.find("select[name=board-type]").val(),
                refresh             = form.find("input[name=refresh-interval]").prop('checked'),
                showAssignees       = form.find("input[name=showAssignees]").prop('checked'),
                showRapidViewName   = form.find("input[name=showRapidViewName]").prop('checked'),
                showSprintName      = form.find("input[name=showSprintName]").prop('checked'),
                sprintId            = form.find("select[name=sprint-type]").val();

            var configurationParams = {
                isConfigured:       isConfigured,
                rapidViewId:        rapidViewId,
                refresh:            refresh == true ? GADGET_REFRESH_INTERVAL : false,
                showAssignees:      showAssignees,
                showRapidViewName:  showRapidViewName,
                showSprintName:     showSprintName,
                sprintId:           sprintId
            };

            AJS.$(this).trigger("submit", configurationParams);
        },

        onCancel : function(){
            AJS.$(this).trigger('cancel');
        },

        onBoardPickerChange: function(){
            AJS.$(this).trigger('boardChange', $(this.boardPicker).val());
        }

    };

    return SprintHealthView;
});