/*
 * Decompiled with CFR 0.152.
 */
package com.pyxis.greenhopper.jira.license;

import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.license.LicensedUserCountService;
import com.atlassian.greenhopper.license.SoftwareAuthorizationService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.pyxis.greenhopper.jira.license.GreenHopperLicenseManager;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class GreenHopperLicenseManagerImpl
implements GreenHopperLicenseManager {
    @Autowired
    private JiraLicenseService jiraLicenseService;
    @Autowired
    private PluginLicenseManager pluginLicenseManager;
    @Autowired
    private LicensedUserCountService licensedUserCountService;
    @Autowired
    private JiraForSoftwareChecker jiraForSoftwareChecker;
    @Autowired
    private SoftwareAuthorizationService softwareAuthorizationService;

    @Override
    public String getServerId() {
        return this.jiraLicenseService.getServerId();
    }

    private JiraLicense getJIRALicense() {
        return this.getProductLicenseDetails().getJiraLicense();
    }

    private LicenseDetails getProductLicenseDetails() {
        return (LicenseDetails)this.jiraLicenseService.getLicenses().iterator().next();
    }

    @Override
    public String getLicenseRedirectUrl() {
        return "/plugins/servlet/upm#manage/com.pyxis.greenhopper.jira";
    }

    @Override
    public void verify() throws LicenseException {
        if (this.jiraForSoftwareChecker.isJiraForSoftwareSupported()) {
            this.softwareAuthorizationService.verifySoftwareLicense();
        } else {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().getOrElse((Object)null);
            if (pluginLicense != null) {
                this.verifyPluginLicense(pluginLicense);
            } else {
                throw new LicenseException("gh.license.not.licensed");
            }
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.verify();
            return true;
        }
        catch (LicenseException e) {
            return false;
        }
    }

    private void verifyPluginLicense(@Nonnull PluginLicense pluginLicense) {
        if (!pluginLicense.isValid()) {
            LicenseError licenseError = (LicenseError)pluginLicense.getError().get();
            if (this.licensedUserCountService.hasExceededUserLimit()) {
                throw new LicenseException("gh.license.jira.user.limit.reached");
            }
            if (LicenseError.EXPIRED.equals((Object)licenseError)) {
                throw new LicenseException("gh.license.expired");
            }
            if (LicenseError.VERSION_MISMATCH.equals((Object)licenseError)) {
                throw new LicenseException("gh.license.oldversion");
            }
            if (LicenseError.EDITION_MISMATCH.equals((Object)licenseError)) {
                throw new LicenseException("gh.license.wrongedition");
            }
            JiraLicense jiraLicense = this.getJIRALicense();
            if (LicenseError.TYPE_MISMATCH.equals((Object)licenseError)) {
                throw new LicenseException(this.getLicenseTypeMismatchMessage(pluginLicense, jiraLicense));
            }
            if (LicenseError.USER_MISMATCH.equals((Object)licenseError)) {
                throw new LicenseException(this.getUserLimitMismatchMessage(pluginLicense, jiraLicense));
            }
        }
    }

    private String getLicenseTypeMismatchMessage(PluginLicense pluginLicense, JiraLicense jiraLicense) {
        String ghType = pluginLicense.isEvaluation() ? "EVALUATION" : pluginLicense.getLicenseType().name();
        String jiraType = jiraLicense.isEvaluation() ? "EVALUATION" : jiraLicense.getLicenseType().name();
        StringBuilder sb = new StringBuilder();
        sb.append("The GreenHopper license type \"").append(ghType).append("\"");
        sb.append(" is incompatible with the JIRA license type \"").append(jiraType).append("\"");
        sb.append("<br>");
        sb.append("Both license types must match.");
        return sb.toString();
    }

    private String getUserLimitMismatchMessage(PluginLicense pluginLicense, JiraLicense jiraLicense) {
        String ghLimit = pluginLicense.isUnlimitedEdition() ? "Unlimited" : String.valueOf(pluginLicense.getEdition());
        String jiraLimit = jiraLicense.isUnlimitedNumberOfUsers() ? "Unlimited" : String.valueOf(jiraLicense.getMaximumNumberOfUsers());
        StringBuilder sb = new StringBuilder();
        sb.append("The GreenHopper user limit (").append(ghLimit).append(")");
        sb.append(" is incompatible with the JIRA user limit (").append(jiraLimit).append(")");
        sb.append("<br>");
        sb.append("The GreenHopper user limit must be equal or greater then the JIRA user limit.");
        return sb.toString();
    }

    public void setLicense(String licenseString) {
        throw new UnsupportedOperationException("Please use UPM to set licenses for greenhopper.");
    }
}

