/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat.local;

import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobHandlerKey;
import com.atlassian.scheduler.compat.JobInfo;
import com.atlassian.scheduler.compat.local.LocalOnlyPluginJob;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOnlyCompatibilityPluginScheduler
implements CompatibilityPluginScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalOnlyCompatibilityPluginScheduler.class);
    private final PluginScheduler pluginScheduler;
    private final ConcurrentMap<JobHandlerKey, JobHandler> handlers = new ConcurrentHashMap<JobHandlerKey, JobHandler>();
    private final ConcurrentMap<String, JobInfo> jobs = new ConcurrentHashMap<String, JobInfo>();

    public LocalOnlyCompatibilityPluginScheduler(PluginScheduler pluginScheduler) {
        this.pluginScheduler = pluginScheduler;
    }

    @Override
    public void registerJobHandler(JobHandlerKey jobHandlerKey, JobHandler jobHandler) {
        JobHandler existing = this.handlers.putIfAbsent(jobHandlerKey, jobHandler);
        if (existing != null) {
            throw new IllegalArgumentException("Job handler already registered: " + jobHandlerKey);
        }
    }

    @Override
    public void unregisterJobHandler(JobHandlerKey jobHandlerKey) {
        this.handlers.remove(Objects.requireNonNull(jobHandlerKey, "jobHandlerKey"));
        Iterator iter = this.jobs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!jobHandlerKey.equals(((JobInfo)entry.getValue()).getJobHandlerKey())) continue;
            iter.remove();
            this.unscheduleClusteredJobImpl((String)entry.getKey());
        }
    }

    @Override
    public void scheduleClusteredJob(String jobKey, JobHandlerKey jobHandlerKey, Date startTime, long repeatInterval) {
        JobHandler jobHandler = (JobHandler)this.handlers.get(jobHandlerKey);
        if (jobHandler == null) {
            throw new IllegalArgumentException("Job handler not registered: " + jobHandlerKey);
        }
        JobInfo jobInfo = new JobInfo(jobKey, jobHandlerKey, startTime, repeatInterval);
        Map<String, Object> jobDataMap = LocalOnlyPluginJob.toJobDataMap(jobInfo, jobHandler);
        if (this.jobs.put(jobKey, jobInfo) != null) {
            this.unscheduleClusteredJobImpl(jobKey);
        }
        this.pluginScheduler.scheduleJob(jobKey, LocalOnlyPluginJob.class, jobDataMap, startTime, repeatInterval);
    }

    @Override
    @Nullable
    public JobInfo getJobInfo(String jobKey) {
        return (JobInfo)this.jobs.get(jobKey);
    }

    @Override
    public void unscheduleClusteredJob(String jobKey) {
        if (this.jobs.remove(jobKey) != null) {
            this.unscheduleClusteredJobImpl(jobKey);
        }
    }

    private void unscheduleClusteredJobImpl(String jobKey) {
        try {
            this.pluginScheduler.unscheduleJob(jobKey);
        }
        catch (IllegalArgumentException iae) {
            LOG.debug("Error unscheduling job " + jobKey, (Throwable)iae);
        }
    }

    @VisibleForTesting
    JobHandler getJobHandler(JobHandlerKey jobHandlerKey) {
        return (JobHandler)this.handlers.get(jobHandlerKey);
    }

    static class UsesJobHandlerKey
    implements Predicate<JobInfo> {
        private final JobHandlerKey jobHandlerKey;

        UsesJobHandlerKey(JobHandlerKey jobHandlerKey) {
            this.jobHandlerKey = jobHandlerKey;
        }

        public boolean apply(JobInfo input) {
            return input.getJobHandlerKey().equals(this.jobHandlerKey);
        }
    }
}

