/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat;

import com.atlassian.annotations.PublicApi;
import com.atlassian.scheduler.compat.JobHandlerKey;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public class JobInfo
implements Serializable {
    private static final long serialVersionUID = 8193091982525403403L;
    private final String jobKey;
    private final JobHandlerKey jobHandlerKey;
    private final Date firstRunDate;
    private final long intervalInMillis;

    public JobInfo(String jobKey, JobHandlerKey jobHandlerKey, Date firstRunDate, long intervalInMillis) {
        this.jobKey = jobKey;
        this.jobHandlerKey = jobHandlerKey;
        this.firstRunDate = firstRunDate != null ? new Date(firstRunDate.getTime()) : null;
        this.intervalInMillis = intervalInMillis;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public JobHandlerKey getJobHandlerKey() {
        return this.jobHandlerKey;
    }

    public Date getFirstRunDate() {
        return this.firstRunDate;
    }

    public long getIntervalInMillis() {
        return this.intervalInMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobInfo jobInfo = (JobInfo)o;
        if (this.intervalInMillis != jobInfo.intervalInMillis) {
            return false;
        }
        if (this.firstRunDate != null ? !this.firstRunDate.equals(jobInfo.firstRunDate) : jobInfo.firstRunDate != null) {
            return false;
        }
        if (!this.jobHandlerKey.equals(jobInfo.jobHandlerKey)) {
            return false;
        }
        return this.jobKey.equals(jobInfo.jobKey);
    }

    public int hashCode() {
        int result = this.jobKey.hashCode();
        result = 31 * result + this.jobHandlerKey.hashCode();
        result = 31 * result + (this.firstRunDate != null ? this.firstRunDate.hashCode() : 0);
        result = 31 * result + (int)(this.intervalInMillis ^ this.intervalInMillis >>> 32);
        return result;
    }

    public String toString() {
        return "JobInfo[jobKey=" + this.jobKey + ",jobHandlerKey=" + this.jobHandlerKey + ",firstRunDate=" + this.firstRunDate + ",intervalInMillis=" + this.intervalInMillis + ']';
    }
}

