/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat;

import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobHandlerKey;
import com.atlassian.scheduler.compat.JobInfo;
import com.atlassian.scheduler.compat.local.LocalOnlyCompatibilityPluginScheduler;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDetectingCompatibilityPluginScheduler
implements CompatibilityPluginScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AutoDetectingCompatibilityPluginScheduler.class);
    private static final String ATLASSIAN_SCHEDULER_CHECK = "com.atlassian.scheduler.SchedulerRuntimeException";
    private static final String ATLASSIAN_SCHEDULER_IMPL = "com.atlassian.scheduler.compat.clustered.ClusteredCompatibilityPluginScheduler";
    private final LazyReference<CompatibilityPluginScheduler> delegateRef = new LazyReference<CompatibilityPluginScheduler>(){

        @Override
        protected CompatibilityPluginScheduler create() throws IllegalAccessException, ClassNotFoundException, InstantiationException {
            return AutoDetectingCompatibilityPluginScheduler.this.createDelegate();
        }
    };
    private final PluginScheduler pluginScheduler;

    public AutoDetectingCompatibilityPluginScheduler(PluginScheduler pluginScheduler) {
        this.pluginScheduler = Objects.requireNonNull(pluginScheduler, "pluginScheduler");
    }

    @Override
    public void registerJobHandler(JobHandlerKey jobHandlerKey, JobHandler jobHandler) {
        this.getDelegate().registerJobHandler(jobHandlerKey, jobHandler);
    }

    @Override
    public void unregisterJobHandler(JobHandlerKey jobHandlerKey) {
        this.getDelegate().unregisterJobHandler(jobHandlerKey);
    }

    @Override
    public void scheduleClusteredJob(String jobKey, JobHandlerKey jobHandlerKey, Date startTime, long repeatInterval) {
        this.getDelegate().scheduleClusteredJob(jobKey, jobHandlerKey, startTime, repeatInterval);
    }

    @Override
    @Nullable
    public JobInfo getJobInfo(String jobKey) {
        return this.getDelegate().getJobInfo(jobKey);
    }

    @Override
    public void unscheduleClusteredJob(String jobKey) {
        this.getDelegate().unscheduleClusteredJob(jobKey);
    }

    private CompatibilityPluginScheduler getDelegate() {
        return this.delegateRef.get();
    }

    CompatibilityPluginScheduler createDelegate() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.isAtlassianSchedulerPresent()) {
            return this.createClusterSafeDelegate();
        }
        return this.createSingleNodeDelegate();
    }

    CompatibilityPluginScheduler createClusterSafeDelegate() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (CompatibilityPluginScheduler)Class.forName(ATLASSIAN_SCHEDULER_IMPL).newInstance();
    }

    CompatibilityPluginScheduler createSingleNodeDelegate() {
        return new LocalOnlyCompatibilityPluginScheduler(this.pluginScheduler);
    }

    boolean isAtlassianSchedulerPresent() {
        try {
            Class.forName(ATLASSIAN_SCHEDULER_CHECK, false, this.getClass().getClassLoader());
            LOG.debug("Looks like the atlassian-scheduler-api is available");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Looks like the atlassian-scheduler-api is NOT available; falling back on SAL", (Throwable)e);
            return false;
        }
    }
}

