/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MemoizingResettingReference<P, T> {
    private final AtomicReference<Supplier<T>> supplierRef = new AtomicReference();
    private final Function<P, T> valueCreator;

    public MemoizingResettingReference(Function<P, T> valueCreator) {
        this.valueCreator = (Function)Preconditions.checkNotNull(valueCreator);
    }

    public T get(final P parameter) {
        Supplier<T> supplier = this.supplierRef.get();
        if (supplier == null) {
            Supplier delegate = new Supplier<T>(){

                public T get() {
                    return MemoizingResettingReference.this.valueCreator.apply(parameter);
                }
            };
            this.supplierRef.compareAndSet(null, new SmarterMemoizingSupplier(delegate));
        }
        supplier = this.supplierRef.get();
        try {
            return (T)supplier.get();
        }
        catch (RuntimeException rte) {
            this.reset();
            throw rte;
        }
    }

    public void reset() {
        this.supplierRef.set(null);
    }

    private static class SmarterMemoizingSupplier<T>
    implements Supplier<T> {
        private AtomicReference<Supplier<T>> delegate;
        private AtomicReference<T> value;
        private AtomicBoolean initialized = new AtomicBoolean(false);

        private SmarterMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = new AtomicReference<Supplier<T>>(delegate);
            this.value = new AtomicReference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (!this.initialized.get()) {
                SmarterMemoizingSupplier smarterMemoizingSupplier = this;
                synchronized (smarterMemoizingSupplier) {
                    if (!this.initialized.get()) {
                        Object t = this.delegate.get().get();
                        this.value.set(t);
                        this.delegate.set(null);
                        this.initialized.set(true);
                    }
                }
            }
            return this.value.get();
        }
    }
}

