/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl;

import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.pocketknife.spi.querydsl.AbstractConnectionProvider;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;

@JiraComponent
public class JiraConnectionProviderImpl
extends AbstractConnectionProvider {
    @Override
    protected Connection getConnectionImpl(boolean autoCommit) {
        DefaultOfBizConnectionFactory instance = this.getDefaultOfBizConnectionFactory();
        this.log().debug("Getting a connection with auto-commit '" + autoCommit + "' using a DefaultOfBizConnectionFactory");
        try {
            Connection connection = instance.getConnection();
            connection.setAutoCommit(autoCommit);
            this.log().debug("Got connection with auto-commit '" + autoCommit + "'");
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    DefaultOfBizConnectionFactory getDefaultOfBizConnectionFactory() {
        return DefaultOfBizConnectionFactory.getInstance();
    }
}

