/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.lifecycle.modules;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.StateAware;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.pocketknife.internal.lifecycle.modules.GhettoCode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DynamicModuleRegistration {
    private static final Logger log = LoggerFactory.getLogger(DynamicModuleRegistration.class);
    private final BundleContext bundleContext;

    @Autowired
    public DynamicModuleRegistration(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ModuleRegistrationHandle registerDescriptors(Plugin plugin, Iterable<ModuleDescriptor> descriptors) {
        BundleContext targetBundleContext = this.bundleContext;
        ArrayList registrations = Lists.newArrayList();
        for (ModuleDescriptor descriptor : descriptors) {
            ModuleDescriptor existingDescriptor = plugin.getModuleDescriptor(descriptor.getKey());
            if (existingDescriptor != null) {
                log.error("Duplicate key '" + descriptor.getKey() + "' detected, disabling previous instance");
                ((StateAware)existingDescriptor).disabled();
            }
            ServiceRegistration serviceRegistration = this.registerModule(targetBundleContext, descriptor);
            registrations.add(new TrackedDynamicModule(serviceRegistration, descriptor));
        }
        return new ModuleRegistrationHandleImpl(registrations);
    }

    private ServiceRegistration registerModule(BundleContext targetBundleContext, ModuleDescriptor descriptor) {
        if (log.isDebugEnabled()) {
            log.debug("Registering descriptor {}", (Object)descriptor.getClass().getName());
        }
        return targetBundleContext.registerService(ModuleDescriptor.class.getName(), (Object)descriptor, null);
    }

    static class ModuleRegistrationHandleImpl
    implements ModuleRegistrationHandle {
        private final List<TrackedDynamicModule> registrations;
        private final List<ModuleRegistrationHandle> theOthers;

        ModuleRegistrationHandleImpl(List<TrackedDynamicModule> registrations) {
            this(registrations, Collections.emptyList());
        }

        ModuleRegistrationHandleImpl(List<TrackedDynamicModule> registrations, List<ModuleRegistrationHandle> theOthers) {
            this.registrations = registrations;
            this.theOthers = theOthers;
        }

        @Override
        public void unregister() {
            for (ModuleRegistrationHandle theOther : this.theOthers) {
                theOther.unregister();
            }
            for (TrackedDynamicModule reg : this.registrations) {
                reg.unregister();
            }
            this.registrations.clear();
            this.theOthers.clear();
        }

        @Override
        public ModuleRegistrationHandle union(ModuleRegistrationHandle other) {
            return new ModuleRegistrationHandleImpl(this.registrations, this.smoosh(other));
        }

        private List<ModuleRegistrationHandle> smoosh(ModuleRegistrationHandle other) {
            if (other == this) {
                return this.theOthers;
            }
            ArrayList list = Lists.newArrayList();
            list.addAll(this.theOthers);
            list.add(other);
            return list;
        }
    }

    static class TrackedDynamicModule {
        private final ServiceRegistration serviceRegistration;
        private final ModuleDescriptor moduleDescriptor;

        TrackedDynamicModule(ServiceRegistration serviceRegistration, ModuleDescriptor moduleDescriptor) {
            this.serviceRegistration = serviceRegistration;
            this.moduleDescriptor = moduleDescriptor;
        }

        void unregister() {
            try {
                this.serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            GhettoCode.removeModuleDescriptorElement(this.moduleDescriptor.getPlugin(), this.moduleDescriptor.getKey());
        }
    }
}

