/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.lifecycle.modules;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptorFactory;
import com.atlassian.pocketknife.api.lifecycle.modules.DynamicModuleDescriptorFactory;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.pocketknife.internal.lifecycle.modules.CombinedModuleDescriptorFactoryProvider;
import com.atlassian.pocketknife.internal.lifecycle.modules.DynamicModuleRegistration;
import com.atlassian.pocketknife.internal.lifecycle.modules.GhettoCode;
import com.atlassian.pocketknife.internal.lifecycle.modules.PluginDescriptorReader;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DynamicModuleDescriptorFactoryImpl
implements DynamicModuleDescriptorFactory {
    private static final Logger log = LoggerFactory.getLogger(DynamicModuleDescriptorFactoryImpl.class);
    private final DynamicModuleRegistration dynamicModuleRegistration;
    private final CombinedModuleDescriptorFactoryProvider combinedModuleDescriptorFactoryProvider;

    @Autowired
    public DynamicModuleDescriptorFactoryImpl(DynamicModuleRegistration dynamicModuleRegistration, CombinedModuleDescriptorFactoryProvider combinedModuleDescriptorFactoryProvider) {
        this.dynamicModuleRegistration = dynamicModuleRegistration;
        this.combinedModuleDescriptorFactoryProvider = combinedModuleDescriptorFactoryProvider;
    }

    @Override
    public ModuleRegistrationHandle loadModules(Plugin plugin, String ... pathsToAuxAtlassianPluginXMLs) {
        ArrayList modules = Lists.newArrayList();
        ModuleDescriptorFactory moduleDescriptorFactory = this.combinedModuleDescriptorFactoryProvider.getModuleDescriptorFactory();
        for (String auxAtlassianPluginXML : pathsToAuxAtlassianPluginXMLs) {
            PluginDescriptorReader descriptorReader = this.getPluginDescriptorReader(plugin, auxAtlassianPluginXML);
            for (Element moduleElement : descriptorReader.getModules()) {
                String moduleType = moduleElement.getName();
                ModuleDescriptor<?> moduleDescriptor = this.createModuleDescriptor(plugin, moduleType, moduleElement, moduleDescriptorFactory);
                if (moduleDescriptor == null) continue;
                if (moduleDescriptor.getKey() != null && plugin.getModuleDescriptor(moduleDescriptor.getKey()) != null) {
                    throw new PluginParseException("Found duplicate key '" + moduleDescriptor.getKey() + "' within plugin '" + plugin.getKey() + "'");
                }
                if (moduleDescriptor instanceof UnloadableModuleDescriptor) {
                    log.error("There were errors loading the module '" + moduleDescriptor.getName() + "'.");
                    continue;
                }
                log.debug("Loaded module '{}' ", (Object)moduleDescriptor.getKey());
                modules.add(moduleDescriptor);
            }
        }
        return this.dynamicModuleRegistration.registerDescriptors(plugin, modules);
    }

    protected ModuleDescriptor<?> createModuleDescriptor(Plugin plugin, String moduleType, Element element, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        ModuleDescriptor moduleDescriptor;
        try {
            moduleDescriptor = moduleDescriptorFactory.getModuleDescriptor(moduleType);
        }
        catch (Throwable e) {
            UnrecognisedModuleDescriptor descriptor = UnrecognisedModuleDescriptorFactory.createUnrecognisedModuleDescriptor((Plugin)plugin, (Element)element, (Throwable)e, (ModuleDescriptorFactory)moduleDescriptorFactory);
            log.error("There were problems loading the module '{}' in plugin '{}'. The module has been disabled.", (Object)moduleType, (Object)plugin.getName());
            log.error(descriptor.getErrorText(), e);
            return descriptor;
        }
        if (moduleDescriptor == null) {
            log.info("The module '{}' in plugin '{}' is in the list of excluded module descriptors, so not enabling.", (Object)moduleType, (Object)plugin.getName());
            return null;
        }
        String moduleKey = element.attributeValue("key");
        try {
            moduleDescriptor.init(plugin, element);
        }
        catch (Exception e) {
            UnloadableModuleDescriptor descriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor((Plugin)plugin, (Element)element, (Throwable)e, (ModuleDescriptorFactory)moduleDescriptorFactory);
            log.error("There were problems loading the module '{}'. The module and its plugin have been disabled.", (Object)moduleType);
            log.error(descriptor.getErrorText(), (Throwable)e);
            return descriptor;
        }
        GhettoCode.addModuleDescriptorElement(plugin, element, moduleKey);
        return moduleDescriptor;
    }

    private PluginDescriptorReader getPluginDescriptorReader(Plugin plugin, String auxAtlassianPluginXML) {
        log.info(String.format("Reading modules from '%s'", auxAtlassianPluginXML));
        InputStream auxXML = this.readXML(plugin, auxAtlassianPluginXML);
        if (auxXML == null) {
            throw new PluginParseException("Unable to get InputStream for '" + auxAtlassianPluginXML + "'");
        }
        return PluginDescriptorReader.createDescriptorReadert(auxXML);
    }

    private InputStream readXML(Plugin plugin, String pathToAuxPluginsXML) {
        return plugin.getClassLoader().getResourceAsStream(pathToAuxPluginsXML);
    }
}

