/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory.webfragment;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.compatibility.bridge.impl.webfragment.SimpleLinkManagerBridge63Impl;
import com.atlassian.jira.compatibility.bridge.impl.webfragment.SimpleLinkManagerBridge70Impl;
import com.atlassian.jira.compatibility.bridge.webfragment.SimpleLinkManagerBridge;
import com.atlassian.jira.compatibility.detection.MethodDetection;
import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.stereotype.Component;

@Component
public class SimpleLinkManagerBridgeFactory
extends BridgeBeanFactory<SimpleLinkManagerBridge> {
    public SimpleLinkManagerBridgeFactory() {
        super(SimpleLinkManagerBridge.class);
    }

    @Override
    public Object getObject() throws Exception {
        if (this.simpleLinkManagerAcceptsApplicationUser()) {
            return new SimpleLinkManagerBridge70Impl();
        }
        if (this.simpleLinkManagerAcceptsUser()) {
            return new SimpleLinkManagerBridge63Impl();
        }
        throw new IllegalStateException("Unable to select bridge implementation for SimpleLinkManagerBridge. Expecting SimpleLinkManagerBridge to have a 'getLinksForSection' method, which either accepts (String, ApplicationUser, JiraHelper) OR (String, User, JiraHelper) but neither can be found.");
    }

    private boolean simpleLinkManagerAcceptsApplicationUser() {
        return this.checkMethodExistsWithParameterTypes(String.class, ApplicationUser.class, JiraHelper.class);
    }

    private boolean simpleLinkManagerAcceptsUser() {
        return this.checkMethodExistsWithParameterTypes(String.class, User.class, JiraHelper.class);
    }

    private boolean checkMethodExistsWithParameterTypes(Class ... parameterTypes) {
        return MethodDetection.findMethod(SimpleLinkManager.class, "getLinksForSection", parameterTypes).isDefined();
    }
}

