/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory.project.version;

import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.compatibility.bridge.impl.project.version.VersionServiceBridge63Impl;
import com.atlassian.jira.compatibility.bridge.impl.project.version.VersionServiceBridge70Impl;
import com.atlassian.jira.compatibility.bridge.project.version.VersionServiceBridge;
import com.atlassian.jira.compatibility.detection.MethodDetection;
import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.stereotype.Component;

@Component
public class VersionServiceBridgeFactory
extends BridgeBeanFactory<VersionServiceBridge> {
    protected VersionServiceBridgeFactory() {
        super(VersionServiceBridge.class);
    }

    @Override
    public Object getObject() throws Exception {
        if (this.hasNewVersionBuilderMethod() || this.isApplicationUserVersionService()) {
            return new VersionServiceBridge70Impl();
        }
        if (this.hasNewBuilderMethod()) {
            return new VersionServiceBridge63Impl();
        }
        throw new IllegalStateException("Unable to select bridge implementation for VersionServiceBridge. Expecting VersionService to define either 'newVersionBuilder' or 'newBuilder' method");
    }

    private boolean hasNewVersionBuilderMethod() {
        return MethodDetection.findMethod(VersionService.class, "newVersionBuilder", new Class[0]).isDefined();
    }

    private boolean hasNewBuilderMethod() {
        return MethodDetection.findMethod(VersionService.class, "newBuilder", new Class[0]).isDefined();
    }

    private boolean isApplicationUserVersionService() {
        return MethodDetection.findMethod(VersionService.class, "setVersionDetails", ApplicationUser.class, Version.class, String.class, String.class).isDefined();
    }
}

