/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory.project;

import com.atlassian.fugue.Option;
import com.atlassian.jira.compatibility.bridge.impl.project.ProjectManagerBridge63Impl;
import com.atlassian.jira.compatibility.bridge.impl.project.ProjectManagerBridge70Impl;
import com.atlassian.jira.compatibility.bridge.project.ProjectManagerBridge;
import com.atlassian.jira.compatibility.detection.ClassDetection;
import com.atlassian.jira.compatibility.detection.MethodDetection;
import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import com.atlassian.jira.project.ProjectManager;
import org.springframework.stereotype.Component;

@Component
public class ProjectManagerBridgeFactory
extends BridgeBeanFactory<ProjectManagerBridge> {
    protected ProjectManagerBridgeFactory() {
        super(ProjectManagerBridge.class);
    }

    @Override
    public Object getObject() throws Exception {
        if (this.shouldUse70Implementation()) {
            return new ProjectManagerBridge70Impl();
        }
        return new ProjectManagerBridge63Impl();
    }

    private boolean shouldUse70Implementation() {
        Option<? extends Class<?>> projectCreationDataClass = ClassDetection.loadClass("com.atlassian.jira.bc.project.ProjectCreationData");
        if (projectCreationDataClass.isEmpty()) {
            return false;
        }
        return MethodDetection.findMethod(ProjectManager.class, "createProject", (Class)projectCreationDataClass.get()).isDefined();
    }
}

