/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.detection;

import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;

public class MethodDetection {
    @Nonnull
    public static Option<Method> findMethod(@Nonnull Class<?> klass, @Nonnull String methodName, Class ... parameterTypes) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)methodName) ? 1 : 0) != 0, (Object)"methodName must be non-null and non-empty.");
        try {
            Method method = ((Class)Preconditions.checkNotNull(klass)).getMethod(methodName, (Class[])Preconditions.checkNotNull((Object)parameterTypes));
            return Option.some((Object)method);
        }
        catch (NoSuchMethodException ex) {
            return Option.none();
        }
    }

    @Nonnull
    public static Option<Method> findMethod(@Nonnull Class<?> klass, final @Nonnull Type returnedType, @Nonnull String methodName, Class ... parameterTypes) {
        return MethodDetection.findMethod(klass, methodName, parameterTypes).flatMap((Function)new Function<Method, Option<Method>>(){

            public Option<Method> apply(Method method) {
                if (method.getGenericReturnType().equals(returnedType)) {
                    return Option.some((Object)method);
                }
                return Option.none();
            }
        });
    }
}

