/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.workflow;

import com.atlassian.greenhopper.workflow.WorkflowMigrationException;
import com.atlassian.greenhopper.workflow.WorkflowMigrationService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AssignableWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.MigrationHelperFactory;
import io.atlassian.fugue.Option;
import java.util.concurrent.RejectedExecutionException;
import org.ofbiz.core.entity.GenericEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowMigrationServiceImpl
implements WorkflowMigrationService {
    @Autowired
    private MigrationHelperFactory migrationHelperFactory;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private WorkflowSchemeManager workflowSchemeManager;

    @Override
    public Option<TaskDescriptor<WorkflowMigrationResult>> doMigrate(long projectId, long workflowSchemeId) throws WorkflowMigrationException {
        boolean quicklyMigrated;
        AssignableWorkflowSchemeMigrationHelper migrationHelper;
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(workflowSchemeId);
        try {
            migrationHelper = this.migrationHelperFactory.createMigrationHelper(project, workflowScheme);
            quicklyMigrated = migrationHelper.doQuickMigrate();
        }
        catch (GenericEntityException e) {
            throw new WorkflowMigrationException(e);
        }
        if (quicklyMigrated) {
            return Option.none();
        }
        if (!migrationHelper.getTypesNeedingMigration().isEmpty()) {
            throw new WorkflowMigrationException("There should not be any issue types needing special migration - the target workflow scheme for Simplified Workflow should be identical to the source scheme.");
        }
        try {
            TaskDescriptor workflowMigrationResultTaskDescriptor = migrationHelper.migrateAsync();
            return Option.some((Object)workflowMigrationResultTaskDescriptor);
        }
        catch (RejectedExecutionException e) {
            throw new WorkflowMigrationException(e);
        }
    }
}

