/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.workflow;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowStringsFactory;
import com.atlassian.greenhopper.workflow.SimplifiedWorkflow70UpgradeService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimplifiedWorkflow70UpgradeServiceImpl
implements SimplifiedWorkflow70UpgradeService {
    private static final String OS_WORKFLOW_ENTRY_NAME = "OSWorkflowEntry";
    private static final String WORKFLOW_SCHEME_ENTITY_NAME = "WorkflowSchemeEntity";
    private static final String WORKFLOW_ENTITY_FIELD = "workflow";
    private static final String DESCRIPTION_ENTITY_FIELD = "description";
    private static final String WORKFLOW_SCHEME_NAME = "WorkflowScheme";
    private static final String LEGACY_WORKFLOW_VERSION_DESC = "Generated by JIRA Agile version";
    private static final String LEGACY_WORKFLOW_NAME = "Agile Simplified Workflow for Project ";
    private static final String LEGACY_WORKFLOW_SCHEME_NAME = ": Agile Simplified Workflow Scheme";
    private static final String KEY_SIMPLIFIED_WORKFLOW_UPGRADED = "JIRA.Software.Simplified.Workflow.Upgraded";
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private WorkflowManager workflowManager;
    @Autowired
    private WorkflowSchemeManager workflowSchemeManager;
    @Autowired
    private SimplifiedWorkflowStringsFactory simplifiedWorkflowStringsFactory;
    @Autowired
    private OfBizDelegator ofBizDelegator;
    @Autowired
    private JiraForSoftwareChecker jiraForSoftwareChecker;
    @Autowired
    private StatusManager statusManager;
    @Autowired
    private PropertyDao propertyDao;
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private LazyReference<SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings> helper = new LazyReference<SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings>(){

        @Override
        protected SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings create() throws Exception {
            return SimplifiedWorkflow70UpgradeServiceImpl.this.simplifiedWorkflowStringsFactory.getSimplifiedWorkflowBrandedStrings();
        }
    };

    @Override
    public void doUpgrade() {
        if (this.jiraForSoftwareChecker.isJiraForSoftwareSupported() && !this.hasUpgradeCompleted()) {
            I18n2 i18n = this.i18nFactoryService.getI18n();
            try {
                this.updateWorkflows(i18n);
                this.updateWorkflowSchemes(i18n);
                this.updateStatuses(i18n);
                this.setUpgradeCompleted(true);
                this.workflowSchemeManager.clearWorkflowCache();
            }
            catch (Exception e) {
                this.log.exception(e);
            }
        }
    }

    private void updateWorkflows(I18n2 i18n) {
        Collection workflows = this.workflowManager.getWorkflows();
        for (JiraWorkflow workflow : workflows) {
            String name = workflow.getName();
            String description = workflow.getDescription();
            if (description != null && description.startsWith(LEGACY_WORKFLOW_VERSION_DESC)) {
                this.updateWorkflowDescription(i18n, name, description);
            }
            if (name == null || !name.startsWith(LEGACY_WORKFLOW_NAME)) continue;
            this.updateWorkflowName(name);
        }
    }

    private void updateWorkflowDescription(I18n2 i18n, String name, String description) {
        SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings simplifiedWorkflowStrings = this.helper.get();
        JiraWorkflow mutableWorkflow = this.workflowManager.getWorkflowClone(name);
        String newDescription = description.replace(i18n.getText("agile2015.gh.workflow.simple.workflow.desc"), i18n.getText("gh.workflow.simple.workflow.desc")).replace(LEGACY_WORKFLOW_VERSION_DESC, simplifiedWorkflowStrings.getSimplifiedWorkflowDescriptionPrefix());
        mutableWorkflow.getDescriptor().getMetaAttributes().put("jira.description", newDescription);
        this.workflowManager.saveWorkflowWithoutAudit(mutableWorkflow);
    }

    private void updateWorkflowName(String currentWorkflowName) {
        SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings simplifiedWorkflowStrings = this.helper.get();
        String newName = currentWorkflowName.replace(LEGACY_WORKFLOW_NAME, simplifiedWorkflowStrings.getSimplifiedWorkflowNamePrefix());
        DatabaseIterable<GenericValue> workflowIterator = this.createDatabaseIterator("Workflow", new EntityExpr("name", EntityOperator.EQUALS, (Object)currentWorkflowName));
        WorkflowGenericValueConsumer workflowConsumer = new WorkflowGenericValueConsumer("name", newName, "Workflow " + currentWorkflowName);
        workflowIterator.foreach((Consumer)workflowConsumer);
        DatabaseIterable<GenericValue> workflowSchemeIterator = this.createDatabaseIterator(WORKFLOW_SCHEME_ENTITY_NAME, new EntityExpr(WORKFLOW_ENTITY_FIELD, EntityOperator.EQUALS, (Object)currentWorkflowName));
        WorkflowGenericValueConsumer workflowSchemeConsumer = new WorkflowGenericValueConsumer(WORKFLOW_ENTITY_FIELD, newName);
        workflowSchemeIterator.foreach((Consumer)workflowSchemeConsumer);
        DatabaseIterable<GenericValue> workflowEntryIterator = this.createDatabaseIterator(OS_WORKFLOW_ENTRY_NAME, new EntityExpr("name", EntityOperator.EQUALS, (Object)currentWorkflowName));
        WorkflowGenericValueConsumer workflowEntryConsumer = new WorkflowGenericValueConsumer("name", newName);
        workflowEntryIterator.foreach((Consumer)workflowEntryConsumer);
    }

    private void updateWorkflowSchemes(I18n2 i18n) {
        List schemes = this.workflowSchemeManager.getSchemeObjects();
        String legacyWorkflowSchemeDescription = i18n.getText("agile2015.gh.workflow.simple.workflow.scheme.desc");
        String newWorkflowSchemeDescription = i18n.getText("gh.workflow.simple.workflow.scheme.desc");
        SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings simplifiedWorkflowStrings = this.helper.get();
        for (Scheme scheme : schemes) {
            String description;
            String schemeName = scheme.getName();
            if (schemeName != null && schemeName.contains(LEGACY_WORKFLOW_SCHEME_NAME)) {
                String updatedName = schemeName.replace(LEGACY_WORKFLOW_SCHEME_NAME, simplifiedWorkflowStrings.getSimplifiedWorkflowSchemeNameV3Suffix());
                this.updateWorkflowSchemeName(scheme.getId(), updatedName);
            }
            if ((description = scheme.getDescription()) == null || !description.contains(LEGACY_WORKFLOW_VERSION_DESC)) continue;
            String updatedDescription = description.replace(LEGACY_WORKFLOW_VERSION_DESC, simplifiedWorkflowStrings.getSimplifiedWorkflowDescriptionPrefix()).replace(legacyWorkflowSchemeDescription, newWorkflowSchemeDescription);
            this.updateWorkflowSchemeDescription(scheme.getId(), updatedDescription);
        }
    }

    private void updateStatuses(I18n2 i18n) {
        Collection statuses = this.statusManager.getStatuses();
        String legacyStatusDescription = i18n.getText("agile2015.gh.workflow.simple.workflow.status.desc");
        String newStatusDescription = i18n.getText("gh.workflow.simple.workflow.status.desc");
        for (Status status : statuses) {
            String description = status.getDescription();
            if (!StringUtils.equals((String)legacyStatusDescription, (String)description)) continue;
            this.statusManager.editStatus(status, status.getName(), newStatusDescription, status.getIconUrl());
        }
    }

    private void updateWorkflowSchemeDescription(Long id, String updatedDescription) {
        GenericValue workflowSchemeEntity = this.ofBizDelegator.findById(WORKFLOW_SCHEME_NAME, id);
        this.updateGenericValue(workflowSchemeEntity, DESCRIPTION_ENTITY_FIELD, updatedDescription, "Workflow scheme " + id);
    }

    private void updateWorkflowSchemeName(Long id, String updatedName) {
        GenericValue workflowSchemeEntity = this.ofBizDelegator.findById(WORKFLOW_SCHEME_NAME, id);
        this.updateGenericValue(workflowSchemeEntity, "name", updatedName, "Workflow scheme " + id);
    }

    private boolean hasUpgradeCompleted() {
        Boolean value = this.propertyDao.getBooleanProperty(KEY_SIMPLIFIED_WORKFLOW_UPGRADED);
        return value != null && value != false;
    }

    private void setUpgradeCompleted(boolean newValue) {
        this.propertyDao.setBooleanProperty(KEY_SIMPLIFIED_WORKFLOW_UPGRADED, newValue);
    }

    private DatabaseIterable<GenericValue> createDatabaseIterator(final String entityName, final EntityExpr ... conditions) {
        return new DatabaseIterable<GenericValue>(-1, new NoOpResolver()){

            protected OfBizListIterator createListIterator() {
                ArrayList conditionList = new ArrayList();
                Collections.addAll(conditionList, conditions);
                EntityConditionList conditions2 = new EntityConditionList(conditionList, EntityOperator.AND);
                return SimplifiedWorkflow70UpgradeServiceImpl.this.ofBizDelegator.findListIteratorByCondition(entityName, (EntityCondition)conditions2);
            }
        };
    }

    private void updateGenericValue(GenericValue genericValue, String fieldName, String newValue, String errorMessage) {
        genericValue.set(fieldName, (Object)newValue);
        try {
            genericValue.store();
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class NoOpResolver<E>
    implements Resolver<E, E> {
        private NoOpResolver() {
        }

        public E apply(E input) {
            return input;
        }
    }

    private class WorkflowGenericValueConsumer
    implements Consumer<GenericValue> {
        private final String fieldName;
        private final String newName;
        private final String errorMessage;

        private WorkflowGenericValueConsumer(String fieldName, String newName) {
            this(fieldName, newName, (String)null);
        }

        public WorkflowGenericValueConsumer(String fieldName, String newName, String errorMessage) {
            this.fieldName = fieldName;
            this.newName = newName;
            this.errorMessage = errorMessage;
        }

        public void consume(@Nonnull GenericValue genericValue) {
            String errorMessage = this.errorMessage;
            if (this.errorMessage == null) {
                errorMessage = String.format("%s[%s]", genericValue.getEntityName(), genericValue.get("id"));
            }
            SimplifiedWorkflow70UpgradeServiceImpl.this.updateGenericValue(genericValue, this.fieldName, this.newName, errorMessage);
        }
    }
}

