/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.webhooks.sprint;

import com.atlassian.greenhopper.api.events.sprint.SprintUpdatedEvent;
import com.atlassian.greenhopper.api.rest.bean.SprintBean;
import com.atlassian.greenhopper.api.rest.bean.SprintBeanFactory;
import com.atlassian.greenhopper.webhooks.AbstractEventSerializer;
import com.atlassian.greenhopper.webhooks.RegisteredWebHookEventFactory;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SprintUpdatedEventSerializer
extends AbstractEventSerializer<SprintUpdatedEvent> {
    private final SprintBeanFactory sprintBeanFactory;

    @Autowired
    public SprintUpdatedEventSerializer(RegisteredWebHookEventFactory registeredWebHookEventFactory, SprintBeanFactory sprintBeanFactory) {
        super(registeredWebHookEventFactory);
        this.sprintBeanFactory = sprintBeanFactory;
    }

    @Override
    protected ImmutableMap.Builder<String, Object> putFields(SprintUpdatedEvent event, ImmutableMap.Builder<String, Object> defaultJson) {
        SprintBean bean = this.sprintBeanFactory.toBean(event.getSprint());
        SprintBean previousBean = this.sprintBeanFactory.toBean(event.getPreviousValue());
        defaultJson.put((Object)"sprint", (Object)bean);
        defaultJson.put((Object)"oldValue", (Object)previousBean);
        return defaultJson;
    }
}

