/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.webhooks.board;

import com.atlassian.greenhopper.api.events.board.BoardEvent;
import com.atlassian.greenhopper.api.rest.bean.BoardConfigBean;
import com.atlassian.greenhopper.api.rest.bean.BoardConfigBeanFactory;
import com.atlassian.greenhopper.model.rapid.ColumnConfig;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.view.RapidViewConfigManager;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryManager;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.webhooks.AbstractEventSerializer;
import com.atlassian.greenhopper.webhooks.RegisteredWebHookEventFactory;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardConfigurationChangedEventSerializer
extends AbstractEventSerializer<BoardEvent> {
    private final BoardConfigBeanFactory boardConfigBeanFactory;
    private final RapidViewConfigManager rapidViewConfigManager;
    private final SubqueryManager subqueryManager;

    @Autowired
    public BoardConfigurationChangedEventSerializer(RegisteredWebHookEventFactory registeredWebHookEventFactory, BoardConfigBeanFactory boardConfigBeanFactory, RapidViewConfigManager rapidViewConfigManager, SubqueryManager subqueryManager) {
        super(registeredWebHookEventFactory);
        this.boardConfigBeanFactory = boardConfigBeanFactory;
        this.rapidViewConfigManager = rapidViewConfigManager;
        this.subqueryManager = subqueryManager;
    }

    @Override
    protected ImmutableMap.Builder<String, Object> putFields(BoardEvent event, ImmutableMap.Builder<String, Object> defaultJson) {
        RapidView board = event.getBoard();
        ColumnConfig columnConfig = this.rapidViewConfigManager.getColumnConfig(board);
        EstimationConfig estimationConfig = this.rapidViewConfigManager.getEstimationConfig(board);
        Long rankFieldId = this.rapidViewConfigManager.getRankFieldId(board);
        Subquery subquery = board.getType() == RapidView.Type.KANBAN ? this.subqueryManager.getSubquery(board) : null;
        BoardConfigBean bean = this.boardConfigBeanFactory.toBean(board, rankFieldId, columnConfig, estimationConfig, subquery);
        defaultJson.put((Object)"configuration", (Object)bean);
        return defaultJson;
    }
}

