/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.webhooks;

import com.atlassian.greenhopper.api.events.board.BoardConfigurationChangedEvent;
import com.atlassian.greenhopper.api.events.board.BoardCreatedEvent;
import com.atlassian.greenhopper.api.events.board.BoardDeletedEvent;
import com.atlassian.greenhopper.api.events.board.BoardUpdatedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintClosedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintCreatedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintDeletedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintStartedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintUpdatedEvent;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.util.EventMatchers;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.springframework.stereotype.Component;

@Component
public class RegisteredWebHookEventFactory {
    private final WebHookEventSection agileSection;
    private Iterable<? extends RegisteredWebHookEvent> allEvents;

    public RegisteredWebHookEventFactory() {
        WebHookEventGroup sprintGroup = WebHookEventGroup.builder().nameI18nKey("jira.software.webhook.group.sprint").addEvent(this.event("sprint_created", "jira.software.webhook.group.sprint.created", SprintCreatedEvent.class)).addEvent(this.event("sprint_deleted", "jira.software.webhook.group.sprint.deleted", SprintDeletedEvent.class)).addEvent(this.event("sprint_updated", "jira.software.webhook.group.sprint.updated", SprintUpdatedEvent.class)).addEvent(this.event("sprint_started", "jira.software.webhook.group.sprint.started", SprintStartedEvent.class)).addEvent(this.event("sprint_closed", "jira.software.webhook.group.sprint.closed", SprintClosedEvent.class)).build();
        WebHookEventGroup boardGroup = WebHookEventGroup.builder().nameI18nKey("jira.software.webhook.group.board").addEvent(this.event("board_created", "jira.software.webhook.group.board.created", BoardCreatedEvent.class)).addEvent(this.event("board_deleted", "jira.software.webhook.group.board.deleted", BoardDeletedEvent.class)).addEvent(this.event("board_updated", "jira.software.webhook.group.board.updated", BoardUpdatedEvent.class)).addEvent(this.event("board_configuration_changed", "jira.software.webhook.group.board.configuration.changed", BoardConfigurationChangedEvent.class)).build();
        this.agileSection = WebHookEventSection.section((String)"agile-events-section").nameI18nKey("jira.software.webhook.section.agile").descriptionI18nKey("jira.software.webhook.section.agile.description").addGroup(sprintGroup).addGroup(boardGroup).build();
        this.allEvents = Iterables.concat((Iterable)Iterables.transform((Iterable)this.agileSection.getGroups(), (Function)new Function<WebHookEventGroup, Iterable<RegisteredWebHookEvent>>(){

            public Iterable<RegisteredWebHookEvent> apply(WebHookEventGroup group) {
                return group.getEvents();
            }
        }));
    }

    public WebHookEventSection getAgileSection() {
        return this.agileSection;
    }

    public <T> RegisteredWebHookEvent getWebHookIdForEvent(T event) {
        for (RegisteredWebHookEvent registeredWebHookEvent : this.allEvents) {
            if (!registeredWebHookEvent.getEventClass().isInstance(event)) continue;
            return registeredWebHookEvent;
        }
        throw new IllegalStateException("No matching WebHookJiraEvent found for event " + event);
    }

    private RegisteredWebHookEvent event(String id, String namei18nKey, Class<?> eventClass) {
        return RegisteredWebHookEvent.withId((String)id).andDisplayName(namei18nKey).firedWhen(eventClass).isMatchedBy(EventMatchers.ALWAYS_TRUE);
    }
}

