/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.webhooks;

import com.atlassian.greenhopper.webhooks.RegisteredWebHookEventFactory;
import com.atlassian.plugins.rest.common.json.JacksonJsonProviderFactory;
import com.atlassian.webhooks.spi.EventSerializer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Date;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public abstract class AbstractEventSerializer<T>
implements EventSerializer<T> {
    private final RegisteredWebHookEventFactory registeredWebHookEventFactory;

    public AbstractEventSerializer(RegisteredWebHookEventFactory registeredWebHookEventFactory) {
        this.registeredWebHookEventFactory = registeredWebHookEventFactory;
    }

    protected abstract ImmutableMap.Builder<String, Object> putFields(T var1, ImmutableMap.Builder<String, Object> var2);

    protected ImmutableMap.Builder<String, Object> defaultFields(T event) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"timestamp", (Object)this.getTimeStamp());
        builder.put((Object)"webhookEvent", (Object)this.resolveEventName(event));
        return builder;
    }

    public final String serialize(T event) {
        return JacksonSerializer.serialize(this.putFields(event, this.defaultFields(event)).build());
    }

    private Long getTimeStamp() {
        return new Date().getTime();
    }

    private String resolveEventName(T event) {
        return this.registeredWebHookEventFactory.getWebHookIdForEvent(event).getId();
    }

    private static class JacksonSerializer {
        private static final JacksonJsonProvider JACKSON_JSON_PROVIDER = new JacksonJsonProviderFactory().create();

        private JacksonSerializer() {
        }

        public static String serialize(Object object) {
            try {
                return JACKSON_JSON_PROVIDER.locateMapper(object.getClass(), MediaType.APPLICATION_JSON_TYPE).writeValueAsString(object);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

