/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.util;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.util.BuildProperties;
import com.atlassian.greenhopper.web.rapid.issue.IssueOperationsHelper;
import com.atlassian.greenhopper.web.util.DatePickerHelper;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.util.FieldsResourceIncluder;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-webUtilities")
public class WebUtilities {
    public static final String SERVICE = "gh-webUtilities";
    @Autowired
    private WebResourceManager webResourceManager;
    @Autowired
    private FieldsResourceIncluder fieldResourceIncluder;
    @Autowired
    private KeyboardShortcutManager keyboardShortcutManager;
    @Autowired
    private UserPreferencesManager userPreferencesManager;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private DatePickerHelper datePickerHelper;
    @Autowired
    private BuildProperties buildProperties;
    @Autowired
    private IssueOperationsHelper issueOperationsHelper;
    @Autowired
    private JiraBaseUrls jiraBaseUrls;

    public String getResourceLocation(String moduleName, String resourceName) {
        String location = this.webResourceManager.getStaticPluginResource("com.pyxis.greenhopper.jira:" + moduleName, resourceName, UrlMode.RELATIVE);
        return location.replace("/2/_", "/" + this.buildProperties.getVersion() + "/_");
    }

    public String getModifierKey() {
        return BrowserUtils.getModifierKey();
    }

    public void registerKeyboardContext() {
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.greenhopper);
    }

    public void includeFieldResourcesForCurrentUser() {
        this.fieldResourceIncluder.includeFieldResourcesForCurrentUser();
    }

    public static String encodeHtml(String txt) {
        if (txt == null || txt.trim().equals("")) {
            return "";
        }
        return TextUtils.htmlEncode((String)txt).replace("'", "&#39;").replace(System.getProperty("line.separator"), "&#10;");
    }

    public static String decodeHtml(String txt) {
        if (txt == null || txt.trim().equals("")) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml4(txt);
    }

    public static String urlEncode(String txt) {
        if (txt == null || txt.trim().equals("")) {
            return "";
        }
        try {
            return URLEncoder.encode(txt, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return txt;
        }
    }

    public String encodeJson(String text) {
        return JSONEscaper.escape((String)text);
    }

    public String encodeInlineJson(String json) {
        return json.replace("/", "\\/");
    }

    public DatePickerHelper getDatePicker() {
        return this.datePickerHelper;
    }

    public boolean isDateOverdue(DateMidnight date) {
        if (date == null) {
            return false;
        }
        return date.isBefore((ReadableInstant)new DateMidnight());
    }

    public Locale getLocale(ApplicationUser user) {
        String locale = this.userPreferencesManager.getPreferences(user).getString("jira.user.locale");
        return !StringUtils.isBlank((CharSequence)locale) ? LocaleParser.parseLocale((String)locale) : this.applicationProperties.getDefaultLocale();
    }

    public void validateStringSpecialCharacters(String str, ErrorCollection errorCollection) {
        if (str.indexOf(60) >= 0 || str.indexOf(62) >= 0 || str.indexOf("\"") >= 0 || str.indexOf(39) >= 0 || str.indexOf(";") >= 0 || str.indexOf(":") >= 0 || str.indexOf("#") >= 0 || str.indexOf("/") >= 0 || str.indexOf("$") >= 0 || str.indexOf("&") >= 0 || str.indexOf("\\") >= 0 || str.indexOf("&") >= 0) {
            errorCollection.addError("gh.error.illegalchar", new Object[0]);
        }
    }

    public static Collection<Long> asLongList(String[] values) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String value : values) {
            if (value.equals("")) continue;
            list.add(Long.valueOf(value));
        }
        return list;
    }

    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    public Collection<SimpleLink> getIssueOperations() {
        return this.issueOperationsHelper.getIssueOperations();
    }

    public String convertRelativeUrlToAbsolute(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String contextPath = ExecutingHttpRequest.get().getContextPath();
            String baseUrl = this.jiraBaseUrls.baseUrl();
            if (url.startsWith("http://") || url.startsWith("https://")) {
                return url;
            }
            if (url.startsWith(contextPath)) {
                return baseUrl + url.substring(contextPath.length());
            }
            return baseUrl + url;
        }
        return url;
    }
}

