/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.util;

import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.concurrent.Callable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class RestCall {
    private final Logger logger;
    private final Class restClass;

    public RestCall(Class restClass) {
        this.restClass = (Class)Assertions.notNull((String)"restClass", (Object)restClass);
        this.logger = null;
    }

    public Response response(Callable<Response> callable) {
        try {
            return callable.call();
        }
        catch (Throwable t) {
            WebApplicationException webApplicationException;
            Response response;
            Logger logger = this.getLogger();
            if (t instanceof WebApplicationException && (response = (webApplicationException = (WebApplicationException)t).getResponse()) != null) {
                int statusCode = response.getStatus();
                String shortErrorMessage = t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage();
                String logMessage = String.format("GreenHopper REST method failed with SC = %d - %s", statusCode, shortErrorMessage);
                RestCall.logForStatus(logger, statusCode, logMessage);
                Object entity = response.getEntity();
                if (entity != null && entity instanceof JiraCopiedRestErrorCollection) {
                    JiraCopiedRestErrorCollection errors = (JiraCopiedRestErrorCollection)entity;
                    RestCall.logForStatus(logger, statusCode, errors.toString());
                }
                return response;
            }
            logger.error((Object)"Unable to complete GreenHopper REST method ", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static void logForStatus(Logger logger, int statusCode, String logMessage) {
        if (statusCode >= Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            logger.warn((Object)logMessage);
        } else {
            logger.info((Object)logMessage);
        }
    }

    private Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return Logger.getLogger((Class)this.restClass);
    }
}

