/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.util;

import com.atlassian.greenhopper.features.SoftwareHelpSpaceProvider;
import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.web.util.HelpPathFileLoader;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GreenHopperHelpPathResolver {
    private final Logger log = Logger.getLogger(GreenHopperHelpPathResolver.class);
    public static final String SOFTWARE_HELP_PATH_CONFIG_LOCATION = "gh-help-paths.properties";
    public static final String AGILE_HELP_PATH_CONFIG_LOCATION = "agile-help-paths.properties";
    private static final String URL_PROPERTY_IDENTIFIER = ".url";
    private static final String CLOUD_PROPERTY_IDENTIFIER = ".ondemand";
    private static final String ALT_PROPERTY_IDENTIFIER = ".alt";
    private static final String TITLE_PROPERTY_IDENTIFIER = ".title";
    private static final String DEFAULT_URL_KEY = "default";
    private static final String SERVER_URL_PREFIX_KEY = "url-prefix";
    private static final String CLOUD_URL_PREFIX_KEY = "url-prefix.ondemand";
    private static final String URL_SUFFIX_KEY = "url-suffix";
    private static final String SOFTWARE_HELP_SPACE_PLACEHOLDER = "${software.help.space}";
    private final JiraForSoftwareChecker jiraForSoftwareChecker;
    private final FeatureManager featureManager;
    private final SoftwareHelpSpaceProvider softwareHelpSpaceProvider;
    private final HelpPathFileLoader helpPathFileLoader;
    private HelpPath defaultHelpPath;
    private final LazyReference<Map<String, HelpPath>> helpPaths = new LazyReference<Map<String, HelpPath>>(){

        @Override
        protected Map<String, HelpPath> create() throws Exception {
            Properties properties = GreenHopperHelpPathResolver.this.helpPathFileLoader.loadProperties(GreenHopperHelpPathResolver.this.getHelpPathConfigLocation());
            return GreenHopperHelpPathResolver.this.loadExternalProperties(properties);
        }
    };

    @Autowired
    public GreenHopperHelpPathResolver(JiraForSoftwareChecker jiraForSoftwareChecker, FeatureManager featureManager, SoftwareHelpSpaceProvider softwareHelpSpaceProvider, HelpPathFileLoader helpPathFileLoader) {
        this.jiraForSoftwareChecker = jiraForSoftwareChecker;
        this.featureManager = featureManager;
        this.softwareHelpSpaceProvider = softwareHelpSpaceProvider;
        this.helpPathFileLoader = helpPathFileLoader;
    }

    public HelpPath getHelpPath(String helpPathKey) {
        HelpPath theHelpPath = this.helpPaths.get().get(helpPathKey);
        if (theHelpPath == null) {
            return this.defaultHelpPath;
        }
        return theHelpPath;
    }

    private String getHelpPathConfigLocation() {
        if (this.jiraForSoftwareChecker.isJiraForSoftwareSupported()) {
            return SOFTWARE_HELP_PATH_CONFIG_LOCATION;
        }
        return AGILE_HELP_PATH_CONFIG_LOCATION;
    }

    private String replaceSoftwareHelpSpacePlaceholder(String url) {
        if (this.jiraForSoftwareChecker.isJiraForSoftwareSupported()) {
            Option<String> helpSpace = this.softwareHelpSpaceProvider.getHelpSpace();
            if (helpSpace.isEmpty()) {
                this.log.error((Object)"GreenHopperHelpPathResolver failed to fetch version number of JIRA Software Application to form help space links with.");
            } else {
                url = url.replace(SOFTWARE_HELP_SPACE_PLACEHOLDER, (CharSequence)helpSpace.get());
            }
        }
        return url;
    }

    public Set<String> keySet() {
        return new HashSet<String>(this.helpPaths.get().keySet());
    }

    private Properties filterByEnvironment(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        Properties filteredProperties = new Properties();
        boolean isCloudEnvironment = this.isCloudEnvironment();
        HashSet cloudKeys = Sets.newHashSet();
        while (propertyNames.hasMoreElements()) {
            String propertyKey = (String)propertyNames.nextElement();
            filteredProperties.setProperty(propertyKey, properties.getProperty(propertyKey));
            if (!this.isCloudProperty(propertyKey)) continue;
            cloudKeys.add(propertyKey);
        }
        if (isCloudEnvironment) {
            for (String cloudKey : cloudKeys) {
                String baseKey = cloudKey.replace(CLOUD_PROPERTY_IDENTIFIER, "");
                filteredProperties.setProperty(baseKey, properties.getProperty(cloudKey));
            }
        } else {
            for (String cloudKey : cloudKeys) {
                filteredProperties.remove(cloudKey);
            }
        }
        return filteredProperties;
    }

    private Properties filterUrls(Properties properties, String urlPrefix, String urlSuffix) {
        Enumeration<?> propertyNames = properties.propertyNames();
        Properties filteredProperties = new Properties();
        while (propertyNames.hasMoreElements()) {
            String propertyKey = (String)propertyNames.nextElement();
            if (this.isUrlProperty(propertyKey)) {
                String currentPrefix = urlPrefix;
                if (this.isExternalLink(properties.getProperty(propertyKey))) {
                    currentPrefix = "";
                }
                String url = this.buildValidUrl(currentPrefix, properties.getProperty(propertyKey), urlSuffix);
                filteredProperties.setProperty(propertyKey.replace(URL_PROPERTY_IDENTIFIER, ""), url);
                continue;
            }
            filteredProperties.setProperty(propertyKey, properties.getProperty(propertyKey));
        }
        return filteredProperties;
    }

    @VisibleForTesting
    Map<String, HelpPath> loadExternalProperties(Properties properties) {
        HashMap<String, HelpPath> result = new HashMap<String, HelpPath>();
        String urlPrefix = this.getUrlPrefix(properties);
        String urlSuffix = properties.containsKey(URL_SUFFIX_KEY) ? properties.getProperty(URL_SUFFIX_KEY) : "";
        Properties filteredProperties = this.filterUrls(properties, urlPrefix, urlSuffix);
        filteredProperties = this.filterByEnvironment(filteredProperties);
        Enumeration<?> propertyNames = filteredProperties.propertyNames();
        this.defaultHelpPath = this.loadHelpPath(DEFAULT_URL_KEY, properties, urlPrefix, urlSuffix, null);
        while (propertyNames.hasMoreElements()) {
            String property = (String)propertyNames.nextElement();
            HelpPath helpPath = this.loadHelpPath(property, filteredProperties, "", "", this.defaultHelpPath);
            result.put(helpPath.getKey(), helpPath);
        }
        return result;
    }

    private HelpPath loadHelpPath(String name, Properties props, String prefix, String suffix, HelpPath defaultHelpPath) {
        String title;
        HelpPath helpPath = defaultHelpPath == null ? new HelpPath() : (HelpPath)defaultHelpPath.clone();
        helpPath.setKey(name);
        helpPath.setUrl(props.getProperty(name));
        helpPath.setLocal(Boolean.FALSE);
        String alt = props.getProperty(name + ALT_PROPERTY_IDENTIFIER);
        if (alt != null) {
            helpPath.setAlt(alt);
        }
        if ((title = props.getProperty(name + TITLE_PROPERTY_IDENTIFIER)) != null) {
            helpPath.setTitle(title);
        }
        return helpPath;
    }

    private String buildValidUrl(String prefix, String url, String suffix) {
        String targetUrl = url;
        String targetSuffix = suffix;
        int hashIndex = url.indexOf("#");
        if (hashIndex != -1 && (suffix.contains("?") || suffix.contains("&"))) {
            targetUrl = url.substring(0, hashIndex);
            targetSuffix = suffix + url.substring(hashIndex);
        }
        return prefix + targetUrl + targetSuffix;
    }

    private boolean isExternalLink(String url) {
        String urlLowerCase = url.toLowerCase();
        return urlLowerCase.startsWith("http://") || urlLowerCase.startsWith("https://");
    }

    private boolean isUrlProperty(String propertyName) {
        return propertyName.contains(URL_PROPERTY_IDENTIFIER);
    }

    private boolean isCloudProperty(String propertyName) {
        return propertyName.contains(CLOUD_PROPERTY_IDENTIFIER);
    }

    private String getUrlPrefix(Properties properties) {
        String prefix;
        String string = prefix = properties.containsKey(SERVER_URL_PREFIX_KEY) ? properties.getProperty(SERVER_URL_PREFIX_KEY) : "";
        if (this.isCloudEnvironment()) {
            prefix = properties.containsKey(CLOUD_URL_PREFIX_KEY) ? properties.getProperty(CLOUD_URL_PREFIX_KEY) : prefix;
        }
        return this.replaceSoftwareHelpSpacePlaceholder(prefix);
    }

    private boolean isCloudEnvironment() {
        return this.featureManager.isEnabled(CoreFeatures.ON_DEMAND);
    }

    public class HelpPath
    implements Cloneable {
        String url;
        String alt;
        String title;
        String key;
        Boolean local;

        public String getUrl() {
            return this.url;
        }

        public String getAlt() {
            return this.alt;
        }

        public String getTitle() {
            return this.title;
        }

        public String getKey() {
            return this.key;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setAlt(String alt) {
            this.alt = alt;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Boolean isLocal() {
            return this.local;
        }

        public void setLocal(Boolean local) {
            this.local = local;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                GreenHopperHelpPathResolver.this.log.error((Object)e, (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("url", (Object)this.url).append("title", (Object)this.title).append("key", (Object)this.key).append("alt", (Object)this.alt).toString();
        }
    }
}

