/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.util;

import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDateManager;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateMidnight;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatePickerHelper {
    @Autowired
    private OutlookDateManager outlookDateManager;

    public String getCalendarFormat() {
        return CustomFieldUtils.getDateFormat();
    }

    public static String getCalendarLocale(ApplicationUser user) {
        Locale userLocale = I18nBean.getLocaleFromUser((ApplicationUser)user);
        return !StringUtils.isEmpty((CharSequence)userLocale.getLanguage()) ? userLocale.getLanguage() : "en";
    }

    public Date parseToDate(ApplicationUser user, String date) throws ParseException {
        if (!StringUtils.isEmpty((CharSequence)date)) {
            return this.outlookDateManager.getOutlookDate(new Locale(DatePickerHelper.getCalendarLocale(user))).parseDatePicker(date);
        }
        return null;
    }

    public String parseDateToString(ApplicationUser user, DateMidnight date) {
        if (date == null) {
            return null;
        }
        return this.outlookDateManager.getOutlookDate(new Locale(DatePickerHelper.getCalendarLocale(user))).getDatePickerFormatSample(date.toDate());
    }
}

