/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.util;

import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.util.GreenHopperHelpPathResolver;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class AbstractJsHelpPathsTransformer {
    private final GreenHopperHelpPathResolver greenHopperHelpPathResolver;
    private static final Pattern PATTERN = Pattern.compile("GH\\.HelpPaths\\.getHelpPath\\(\\s*(['\"])([\\w.-]+)\\1\\s*\\)");

    public AbstractJsHelpPathsTransformer(GreenHopperHelpPathResolver greenHopperHelpPathResolver) {
        this.greenHopperHelpPathResolver = greenHopperHelpPathResolver;
    }

    static CharSequence doTransform(CharSequence originalContent, GreenHopperHelpPathResolver greenHopperHelpPathResolver) {
        Matcher matcher = PATTERN.matcher(originalContent);
        StringBuffer output = new StringBuffer();
        ObjectMapper objectMapper = AbstractJsHelpPathsTransformer.createObjectMapper();
        while (matcher.find()) {
            String key = matcher.group(2);
            GreenHopperHelpPathResolver.HelpPath helpPath = greenHopperHelpPathResolver.getHelpPath(key);
            if (helpPath != null) {
                HelpPathTemplate template = AbstractJsHelpPathsTransformer.fromHelpPath(helpPath);
                matcher.appendReplacement(output, "");
                String s = AbstractJsHelpPathsTransformer.writeString(objectMapper, template);
                output.append(s);
                continue;
            }
            matcher.appendReplacement(output, "null");
        }
        matcher.appendTail(output);
        return output;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        objectMapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        objectMapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        return objectMapper;
    }

    private static HelpPathTemplate fromHelpPath(GreenHopperHelpPathResolver.HelpPath helpPath) {
        HelpPathTemplate template = new HelpPathTemplate();
        template.title = helpPath.getTitle();
        template.alt = helpPath.getAlt();
        template.url = helpPath.getUrl();
        template.isLocal = helpPath.isLocal();
        return template;
    }

    private static String writeString(ObjectMapper objectMapper, HelpPathTemplate helpPathTemplate) {
        try {
            return objectMapper.writeValueAsString((Object)helpPathTemplate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @XmlRootElement
    private static class HelpPathTemplate
    extends RestTemplate {
        @XmlElement
        String title;
        @XmlElement
        String alt;
        @XmlElement
        String url;
        @XmlElement
        boolean isLocal;

        private HelpPathTemplate() {
        }
    }

    protected class JsHelpPathsTransformedResource
    extends CharSequenceDownloadableResource {
        public JsHelpPathsTransformedResource(DownloadableResource originalResource) {
            super(originalResource);
        }

        protected CharSequence transform(CharSequence originalContent) {
            return AbstractJsHelpPathsTransformer.doTransform(originalContent, AbstractJsHelpPathsTransformer.this.greenHopperHelpPathResolver);
        }
    }
}

