/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.sidebar;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.sidebar.navigation.NavigationItemService;
import com.atlassian.greenhopper.web.api.ProjectPageContextParameters;
import com.atlassian.greenhopper.web.sidebar.BoardListHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalBoardNavigationPanelContextProvider
implements ContextProvider {
    private final NavigationItemService navigationItemService;
    private final BoardListHelper boardListHelper;
    private final RapidViewQueryService rapidViewQueryService;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public GlobalBoardNavigationPanelContextProvider(NavigationItemService navigationItemService, BoardListHelper boardListHelper, RapidViewQueryService rapidViewQueryService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.navigationItemService = navigationItemService;
        this.boardListHelper = boardListHelper;
        this.rapidViewQueryService = rapidViewQueryService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map getContextMap(Map<String, Object> context) {
        HashMap newContext = Maps.newHashMap();
        newContext.putAll(context);
        Option<RapidView> board = this.boardListHelper.getSelectedBoard(context);
        if (board.isDefined()) {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            newContext.put(ProjectPageContextParameters.SELECTED_BOARD.getKey(), board.get());
            newContext.put(ProjectPageContextParameters.SELECTED_BOARD_ID.getKey(), ((RapidView)board.get()).getId());
            newContext.put(ProjectPageContextParameters.SELECTED_BOARD_TYPE_SCRUM.getKey(), ((RapidView)board.get()).isSprintSupportEnabled());
            Query boardQuery = this.getQuery(user, (RapidView)board.get());
            newContext.put(ProjectPageContextParameters.SELECTED_QUERY.getKey(), boardQuery);
        }
        List items = (List)this.navigationItemService.getItemsInSection("jira.global.board.sidebar.navigation", newContext).getOrElse((Object)Lists.newArrayList());
        newContext.put("items", items);
        newContext.put("tierOne", true);
        newContext.put("id", "sidebar-navigation-panel");
        return newContext;
    }

    private Query getQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        return rapidViewQuery.getValue();
    }
}

