/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.sidebar;

import com.atlassian.greenhopper.features.GlobalBoardDarkFeatureManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.project.SoftwareProjectTypeService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.sidebar.GlobalBoardSidebarRenderer;
import com.atlassian.greenhopper.sidebar.ProjectSidebarRenderer;
import com.atlassian.greenhopper.sidebar.SidebarDarkFeatureManager;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class BoardSidebarRenderer {
    @VisibleForTesting
    static final String SIDEBAR_COLLAPSE_KEY = "sidebar-collapsed-by-default";
    private final GlobalBoardSidebarRenderer globalBoardSidebarRenderer;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectRapidViewService projectRapidViewService;
    private final ProjectService projectService;
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final RapidViewPermissionService rapidViewPermissionService;
    private final SidebarDarkFeatureManager sidebarDarkFeatureManager;
    private final GlobalBoardDarkFeatureManager globalBoardDarkFeatureManager;
    private final SoftwareProjectTypeService softwareProjectTypeService;
    private final PageBuilderService pageBuilderService;

    @Autowired
    public BoardSidebarRenderer(GlobalBoardSidebarRenderer globalBoardSidebarRenderer, JiraAuthenticationContext jiraAuthenticationContext, ProjectRapidViewService projectRapidViewService, ProjectService projectService, ProjectSidebarRenderer projectSidebarRenderer, RapidViewPermissionService rapidViewPermissionService, SidebarDarkFeatureManager sidebarDarkFeatureManager, GlobalBoardDarkFeatureManager globalBoardDarkFeatureManager, SoftwareProjectTypeService softwareProjectTypeService, PageBuilderService pageBuilderService) {
        this.sidebarDarkFeatureManager = sidebarDarkFeatureManager;
        this.globalBoardSidebarRenderer = globalBoardSidebarRenderer;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRapidViewService = projectRapidViewService;
        this.projectService = projectService;
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.rapidViewPermissionService = rapidViewPermissionService;
        this.globalBoardDarkFeatureManager = globalBoardDarkFeatureManager;
        this.softwareProjectTypeService = softwareProjectTypeService;
        this.pageBuilderService = pageBuilderService;
    }

    public String getSidebarHtml(String projectKey, RapidView rapidView) {
        if (this.shouldShowSidebar(projectKey, rapidView)) {
            this.pageBuilderService.assembler().data().requireData(SIDEBAR_COLLAPSE_KEY, Boolean.valueOf(true));
            Option<Project> project = this.getProject(projectKey);
            if (this.shouldShowProjectSidebar(project, rapidView)) {
                return this.getProjectSidebarHtml(project);
            }
            if (this.globalBoardDarkFeatureManager.isEnabled()) {
                return this.getGlobalBoardSidebarHtml(rapidView);
            }
        }
        return "";
    }

    public boolean shouldShowSidebar(String projectKey, RapidView rapidView) {
        return this.sidebarDarkFeatureManager.shouldShowSidebarForCurrentUser() && this.userCanSeeRapidView(rapidView) && this.isProjectCentricOrGlobalBoardSidebarGoingToBeShown(this.getProject(projectKey), rapidView);
    }

    private boolean isProjectCentricOrGlobalBoardSidebarGoingToBeShown(Option<Project> project, RapidView rapidView) {
        return this.globalBoardDarkFeatureManager.isEnabled() || this.shouldShowProjectSidebar(project, rapidView);
    }

    @VisibleForTesting
    boolean shouldShowProjectSidebar(Option<Project> project, RapidView rapidView) {
        return project.isDefined() && this.softwareProjectTypeService.isSoftwareProject((Project)project.get()) && this.projectIsPartOfRapidViewFilter((Project)project.get(), rapidView) && !((Project)project.get()).isArchived();
    }

    @VisibleForTesting
    boolean projectIsPartOfRapidViewFilter(Project project, RapidView rapidView) {
        ServiceOutcome<Set<Project>> outcome = this.projectRapidViewService.findProjectsByRapidView(this.jiraAuthenticationContext.getUser(), rapidView);
        return outcome.isValid() && outcome.getValue() != null && outcome.getValue().contains(project);
    }

    @VisibleForTesting
    boolean userCanSeeRapidView(RapidView rapidView) {
        return rapidView != null && this.rapidViewPermissionService.canSeeRapidView(this.jiraAuthenticationContext.getUser(), rapidView);
    }

    private String getGlobalBoardSidebarHtml(RapidView rapidView) {
        return (String)this.globalBoardSidebarRenderer.render(rapidView.getId(), rapidView.getName(), null).getOrElse((Object)"");
    }

    private String getProjectSidebarHtml(Option<Project> project) {
        Option<String> renderResult = this.projectSidebarRenderer.render(project, null);
        return (String)renderResult.getOrElse((Object)"");
    }

    private Option<Project> getProject(String projectKey) {
        ProjectService.GetProjectResult result = this.projectService.getProjectByKey(this.jiraAuthenticationContext.getUser(), projectKey);
        return Option.option((Object)result.getProject());
    }
}

