/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.sidebar;

import com.atlassian.greenhopper.api.web.projects.BoardScopeFilterContextProvider;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.web.api.ProjectPageContextParameters;
import com.atlassian.greenhopper.web.sidebar.BoardListHelper;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardScopeFilterContextProviderImpl
implements BoardScopeFilterContextProvider {
    static final String FIRST_ISSUE_CREATED_KEY = "firstIssueCreated";
    @Autowired
    private BoardListHelper boardListHelper;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private RapidViewManager rapidViewManager;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private RapidViewHistoryService rapidViewHistoryService;
    @Autowired
    private ProjectPropertiesManager projectPropertiesManager;

    public Map<String, Object> getContext(Project project) {
        if (project == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Option<RapidView> selectedBoard = this.findSelectedBoard(project);
        if (selectedBoard.isDefined()) {
            context.put(ProjectPageContextParameters.SELECTED_BOARD.getKey(), selectedBoard.get());
            context.put(ProjectPageContextParameters.SELECTED_BOARD_ID.getKey(), ((RapidView)selectedBoard.get()).getId());
            context.put(ProjectPageContextParameters.SELECTED_BOARD_TYPE_SCRUM.getKey(), ((RapidView)selectedBoard.get()).isSprintSupportEnabled());
            context.put(ProjectPageContextParameters.SELECTED_QUERY.getKey(), this.getQuery((RapidView)selectedBoard.get()));
            context.put(ProjectPageContextParameters.IS_NO_ISSUES_IN_PROJECT.getKey(), this.isProjectEmpty(project));
        }
        return context;
    }

    private boolean isProjectEmpty(Project project) {
        return !this.hasIssues(project);
    }

    private boolean hasIssues(Project project) {
        PropertySet properties = this.projectPropertiesManager.getPropertySet(project);
        return properties.exists(FIRST_ISSUE_CREATED_KEY) && properties.getBoolean(FIRST_ISSUE_CREATED_KEY);
    }

    private Option<RapidView> findSelectedBoard(Project project) {
        ImmutableMap selectedBoardContext = ImmutableMap.of((Object)"request", (Object)ExecutingHttpRequest.get());
        return Option.option((Object)this.boardListHelper.getSelectedBoard((Map<String, Object>)selectedBoardContext, project.getKey())).orElse(() -> this.lambda$findSelectedBoard$0((Map)selectedBoardContext, project));
    }

    private Query getQuery(RapidView rapidView) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        return rapidViewQuery.getValue();
    }

    private /* synthetic */ Option lambda$findSelectedBoard$0(Map selectedBoardContext, Project project) {
        return Option.option((Object)this.boardListHelper.selectBoard(selectedBoardContext, project.getKey()));
    }
}

