/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.sidebar;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.web.sidebar.BoardListHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BoardPickerListProvider
implements WebItemProvider {
    @Autowired
    private BoardListHelper boardListHelper;
    @Autowired
    private VelocityRequestContextFactory velocityRequestContextFactory;
    private static final String ITEM_SECTION = "jira.project.sidebar.header/project-sidebar-header-scope-filter-list";

    public List<SimpleLink> getLinks(Map<String, Object> context) {
        String projectKey = (String)context.get("projectKey");
        ArrayList links = Lists.newArrayList();
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String baseUrl = requestContext.getBaseUrl();
        List<RapidView> boards = this.boardListHelper.getProjectBoards(projectKey);
        RapidView selectedBoard = this.boardListHelper.getSelectedBoard(context, boards, projectKey);
        for (RapidView board : boards) {
            String itemId = "scope-filter-board-item-" + board.getId();
            SimpleLinkImpl item = new SimpleLinkImpl(itemId, board.getName(), board.getName(), null, null, null, baseUrl + "/secure/RapidBoard.jspa?rapidView=" + board.getId() + "&projectKey=" + projectKey + "&useStoredSettings=true", null, Integer.valueOf(100));
            if (selectedBoard != null && selectedBoard.getId().equals(board.getId())) continue;
            links.add(item);
        }
        return links;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        List<SimpleLink> links = this.getLinks(context);
        return Iterables.transform(links, (Function)new Function<SimpleLink, WebItem>(){

            public WebItem apply(SimpleLink input) {
                return new WebFragmentBuilder(input.getId(), input.getWeight().intValue()).id(input.getId()).label(input.getLabel()).title(input.getTitle()).webItem(BoardPickerListProvider.ITEM_SECTION).url(input.getUrl()).build();
            }
        });
    }
}

