/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.sidebar;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.project.ProjectHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardListHelper {
    public static final String REQUEST_CONTEXT_KEY = "request";
    private static final String RAPID_VIEW_PARAM_NAME = "rapidView";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectHelper projectHelper;
    private final ProjectRapidViewService projectRapidViewService;
    private final RapidViewHistoryService rapidViewHistoryService;
    private final RapidViewService rapidViewService;

    @Autowired
    public BoardListHelper(JiraAuthenticationContext jiraAuthenticationContext, ProjectHelper projectHelper, ProjectRapidViewService projectRapidViewService, RapidViewHistoryService rapidViewHistoryService, RapidViewService rapidViewService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectHelper = projectHelper;
        this.projectRapidViewService = projectRapidViewService;
        this.rapidViewHistoryService = rapidViewHistoryService;
        this.rapidViewService = rapidViewService;
    }

    public List<RapidView> getProjectBoards(String projectKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome<Project> projectOutcome = this.projectHelper.getProjectByKey(user, projectKey);
        if (projectOutcome.isInvalid()) {
            return Collections.emptyList();
        }
        ServiceOutcome<List<RapidView>> projectRapidViewsOutcome = this.projectRapidViewService.findRapidViewsByProject(user, projectOutcome.get());
        if (projectRapidViewsOutcome.isInvalid()) {
            return Collections.emptyList();
        }
        return this.alphabeticalSortOnName(projectRapidViewsOutcome.getValue());
    }

    public RapidView getSelectedBoard(Map<String, Object> context, String projectKey) {
        Option<RapidView> currentRapidView = this.getCurrentRapidViewFromRequestUrl(context);
        if (currentRapidView.isDefined()) {
            return (RapidView)currentRapidView.get();
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome<Project> projectOutcome = this.projectHelper.getProjectByKey(user, projectKey);
        if (projectOutcome.isInvalid()) {
            return null;
        }
        Option<RapidView> mostRecentlyViewedRapidView = this.rapidViewHistoryService.findMostRecentInProject(user, projectOutcome.get());
        if (mostRecentlyViewedRapidView.isDefined()) {
            return (RapidView)mostRecentlyViewedRapidView.get();
        }
        return null;
    }

    @Nonnull
    public Option<RapidView> getSelectedBoard(@Nonnull Map<String, Object> context) {
        ServiceOutcome<RapidView> rapidViewResult;
        Option<Long> rapidViewId = this.getOptionalCurrentRapidViewId(context);
        if (rapidViewId.isDefined() && (rapidViewResult = this.rapidViewService.getRapidView(this.jiraAuthenticationContext.getUser(), (Long)rapidViewId.get())).isValid() && rapidViewResult.getValue() != null) {
            return Option.some((Object)rapidViewResult.getValue());
        }
        RapidView mostRecentlyViewedRapidView = this.rapidViewHistoryService.getMostRecent(this.jiraAuthenticationContext.getUser());
        return mostRecentlyViewedRapidView != null ? Option.some((Object)mostRecentlyViewedRapidView) : Option.none();
    }

    public RapidView selectBoard(Map<String, Object> context, String projectKey) {
        RapidView rapidView = this.getProjectBoards(projectKey).stream().findFirst().orElse(null);
        if (rapidView != null) {
            this.rapidViewHistoryService.storeRapidView(this.jiraAuthenticationContext.getUser(), rapidView);
        }
        return rapidView;
    }

    public RapidView getSelectedBoard(Map<String, Object> context, List<RapidView> boards, String projectKey) {
        RapidView selectedBoard = this.getSelectedBoard(context, projectKey);
        if (selectedBoard != null) {
            return selectedBoard;
        }
        if (boards.size() > 0) {
            return boards.get(0);
        }
        return null;
    }

    private List<RapidView> alphabeticalSortOnName(List<RapidView> boards) {
        Locale userLocale = this.jiraAuthenticationContext.getLocale();
        Collator collator = Collator.getInstance(userLocale);
        ArrayList collatableBoards = Lists.newArrayList();
        for (RapidView board : boards) {
            collatableBoards.add(new CollatableRapidView(collator.getCollationKey(board.getName()), board));
        }
        Collections.sort(collatableBoards);
        ArrayList sortedBoards = Lists.newArrayList();
        for (CollatableRapidView collatableBoard : collatableBoards) {
            sortedBoards.add(collatableBoard.getRapidView());
        }
        return sortedBoards;
    }

    private Option<RapidView> getCurrentRapidViewFromRequestUrl(Map<String, Object> context) {
        Option<Long> optionalCurrentRapidViewId = this.getOptionalCurrentRapidViewId(context);
        if (!optionalCurrentRapidViewId.isDefined()) {
            return Option.none();
        }
        Long currentRapidViewId = (Long)optionalCurrentRapidViewId.get();
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(this.jiraAuthenticationContext.getLoggedInUser(), currentRapidViewId);
        return rapidView.isValid() ? Option.some((Object)rapidView.getValue()) : Option.none();
    }

    private Option<Long> getOptionalCurrentRapidViewId(Map<String, Object> context) {
        Option optionalRapidViewId;
        HttpServletRequest currentRequest = (HttpServletRequest)context.get(REQUEST_CONTEXT_KEY);
        String rapidViewParameter = currentRequest.getParameter(RAPID_VIEW_PARAM_NAME);
        try {
            optionalRapidViewId = Option.some((Object)Long.parseLong(rapidViewParameter));
        }
        catch (NumberFormatException nfe) {
            optionalRapidViewId = Option.none();
        }
        return optionalRapidViewId;
    }

    private static final class CollatableRapidView
    implements Comparable<CollatableRapidView> {
        private final CollationKey collationKey;
        private final RapidView rapidView;

        private CollatableRapidView(CollationKey collationKey, RapidView rapidView) {
            this.collationKey = collationKey;
            this.rapidView = rapidView;
        }

        private RapidView getRapidView() {
            return this.rapidView;
        }

        @Override
        public int compareTo(CollatableRapidView o) {
            return this.collationKey.compareTo(o.collationKey);
        }
    }
}

