/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.remote;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.api.remote.RemoteLinkConversationService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="remoteLinkConversation")
public class RemoteLinkConversationResource
extends AbstractResource {
    private final RemoteLinkConversationService remoteLinkConversationService;

    public RemoteLinkConversationResource(RemoteLinkConversationService remoteLinkConversationService) {
        this.remoteLinkConversationService = remoteLinkConversationService;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getNewConversationToken() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RemoteLinkConversationService.CreationConversation conversation = RemoteLinkConversationResource.this.check(RemoteLinkConversationResource.this.remoteLinkConversationService.startConversation(RemoteLinkConversationResource.this.getUser()));
                return Response.ok((Object)conversation.getToken()).build();
            }
        });
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="statuses")
    public Response listConversationsStatuses(final @QueryParam(value="token") List<String> tokens) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ArrayList<TokenStatus> tokenStatuses = new ArrayList<TokenStatus>(tokens.size());
                for (String token : tokens) {
                    ServiceOutcome<RemoteLinkConversationService.CreationConversation> conversationOutcome = RemoteLinkConversationResource.this.remoteLinkConversationService.getConversation(token);
                    if (!conversationOutcome.isValid()) continue;
                    tokenStatuses.add(new TokenStatus(conversationOutcome.getValue().getToken(), conversationOutcome.getValue().getStatus().name()));
                }
                return Response.ok(tokenStatuses).build();
            }
        });
    }

    @XmlRootElement
    public static class TokenStatus
    extends RestTemplate {
        @XmlElement
        public String token;
        @XmlElement
        public String status;

        public TokenStatus() {
        }

        public TokenStatus(String token, String status) {
            this.token = token;
            this.status = status;
        }
    }
}

