/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.workflow;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.workflow.CheckWorkflowEntitiesByNameResult;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.service.workflow.WorkflowConstantsService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowHelper {
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private WorkflowConstantsService workflowConstantsService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private SimplifiedWorkflowService simplifiedWorkflowService;

    public SimplifiedWorkflowResult isRapidViewUsingGreenHopperSimplifiedWorkflow(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Pair<JiraWorkflow, Project>> ghSimplifiedWorkflow = this.getGreenHopperSimplifiedWorkflow(user, rapidView);
        if (ghSimplifiedWorkflow.isValid()) {
            Project project = (Project)ghSimplifiedWorkflow.getValue().second();
            boolean projectAdministrator = this.permissionService.isProjectAdministrator(user, Collections.singleton(project));
            return SimplifiedWorkflowResult.using(project, projectAdministrator);
        }
        ServiceOutcome<Pair<JiraWorkflow, Project>> potentialSimplifiedWorkflow = this.getPotentialWorkflowForConversion(user, rapidView);
        if (!potentialSimplifiedWorkflow.isValid()) {
            return SimplifiedWorkflowResult.notUsingCantSimplify();
        }
        Project project = (Project)potentialSimplifiedWorkflow.getValue().second();
        return SimplifiedWorkflowResult.notUsingCanSimplify(this.permissionService.isJiraAdministrator(user), project);
    }

    public ServiceOutcome<Pair<JiraWorkflow, Project>> getGreenHopperSimplifiedWorkflow(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        return this.simplifiedWorkflowService.getGreenHopperSimplifiedWorkflow(user, rapidViewQuery.getValue());
    }

    public ServiceOutcome<Pair<JiraWorkflow, Project>> getPotentialWorkflowForConversion(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        return this.simplifiedWorkflowService.getPotentialWorkflowForConversion(user, rapidViewQuery.getValue());
    }

    public ServiceOutcome<JiraWorkflow> getWorkflow(ApplicationUser user, String workflowName) {
        return this.workflowService.getWorkflow(user, workflowName);
    }

    public ServiceOutcome<Status> getStatusById(String statusId) {
        Status status = this.workflowService.getWorkflowStatusObject(statusId);
        if (status == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.status.error.not.found", statusId);
        }
        return ServiceOutcomeImpl.ok(status);
    }

    public ServiceOutcome<List<Status>> getStatusesByIds(List<String> statusIds) {
        ArrayList result = Lists.newArrayList();
        if (statusIds == null) {
            return ServiceOutcomeImpl.ok(result);
        }
        for (String id : statusIds) {
            ServiceOutcome<Status> statusOutcome = this.getStatusById(id);
            if (statusOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(statusOutcome);
            }
            result.add(statusOutcome.getValue());
        }
        return ServiceOutcomeImpl.ok(result);
    }

    public ServiceOutcome<Void> checkForSimplifiedWorkflowNamedAfterProject(ApplicationUser user, Project project) {
        ServiceOutcome<CheckWorkflowEntitiesByNameResult> outcome = this.simplifiedWorkflowService.checkForSimplifiedWorkflowNamedAfterProject(project.getKey());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        CheckWorkflowEntitiesByNameResult result = outcome.getValue();
        if (result.someActive()) {
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            String entityKey = result.workflowActive() ? "gh.common.admin.workflow" : "gh.common.admin.workflow.scheme";
            String entityName = result.workflowActive() ? result.getWorkflowName() : result.getWorkflowSchemeName();
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.project.name.conflict", i18n.getText(entityKey), entityName, project.getName());
        }
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<Status> addStatusToGreenHopperSimplifiedWorkflow(ApplicationUser user, RapidView rapidView, String statusName, Long statusCategoryId) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<Pair<JiraWorkflow, Project>> greenHopperManagedWorkflow = this.getGreenHopperSimplifiedWorkflow(user, rapidView);
        if (!greenHopperManagedWorkflow.isValid()) {
            return ServiceOutcomeImpl.error(greenHopperManagedWorkflow);
        }
        this.validateModifyWorkflow(user, (Project)greenHopperManagedWorkflow.getValue().second(), "gh.rapid.config.workflow.add.status.error.project.admin");
        Status status = this.workflowConstantsService.getOrCreateStatus(statusName, i18n.getText("gh.workflow.simple.workflow.status.desc"), statusCategoryId);
        ServiceOutcome<Void> addStatus = this.simplifiedWorkflowService.addStatusToGreenHopperSimplifiedWorkflow(user, (JiraWorkflow)greenHopperManagedWorkflow.getValue().first(), status);
        if (!addStatus.isValid()) {
            return ServiceOutcomeImpl.error(addStatus);
        }
        return ServiceOutcomeImpl.ok(status);
    }

    public ServiceOutcome<Void> validateModifyWorkflow(ApplicationUser user, Project project, String errorMsgKey) {
        boolean isProjectAdmin = this.permissionService.isProjectAdministrator(user, Collections.singleton(project));
        if (!isProjectAdmin) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, errorMsgKey, project.getName());
        }
        return ServiceOutcomeImpl.ok();
    }

    public static class SimplifiedWorkflowResult {
        private final boolean isUsingSimplifiedWorkflow;
        private final Project simplifiedWorkflowProject;
        private final Boolean isUserAdminOfProject;
        private final Boolean canSimplifyWorkflow;
        private final Boolean userCanSimplifyWorkflow;

        static SimplifiedWorkflowResult notUsingCantSimplify() {
            return new SimplifiedWorkflowResult(false, null, null, false, false);
        }

        static SimplifiedWorkflowResult notUsingCanSimplify(boolean userCanSimplifyWorkflow, Project project) {
            return new SimplifiedWorkflowResult(false, project, null, true, userCanSimplifyWorkflow);
        }

        static SimplifiedWorkflowResult using(Project workflowProject, boolean userAdminOfProject) {
            return new SimplifiedWorkflowResult(true, workflowProject, userAdminOfProject, null, null);
        }

        private SimplifiedWorkflowResult(boolean usingSimplifiedWorkflow, Project simplifiedWorkflowProject, Boolean userAdminOfProject, Boolean canSimplifyWorkflow, Boolean userCanSimplifyWorkflow) {
            this.isUsingSimplifiedWorkflow = usingSimplifiedWorkflow;
            this.simplifiedWorkflowProject = simplifiedWorkflowProject;
            this.isUserAdminOfProject = userAdminOfProject;
            this.canSimplifyWorkflow = canSimplifyWorkflow;
            this.userCanSimplifyWorkflow = userCanSimplifyWorkflow;
        }

        public boolean isUsingSimplifiedWorkflow() {
            return this.isUsingSimplifiedWorkflow;
        }

        public Project getSimplifiedWorkflowProject() {
            return this.simplifiedWorkflowProject;
        }

        public Boolean isUserAdminOfProject() {
            return this.isUserAdminOfProject;
        }

        public Boolean userCanSimplifyWorkflow() {
            return this.userCanSimplifyWorkflow;
        }

        public Boolean canSimplifyWorkflow() {
            return this.canSimplifyWorkflow;
        }
    }
}

