/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.work;

import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.project.ProjectHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorQueryService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.util.ColorUtils;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.EntityData;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntryTransformer;
import com.atlassian.greenhopper.web.rapid.work.WorkData;
import com.atlassian.greenhopper.web.rapid.work.WorkDataFactory;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.transition.TransitionEntry;
import com.atlassian.jira.transition.WorkflowTransitionEntry;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="xboard/work")
@AnonymousAllowed
@Produces(value={"application/json"})
public class WorkResource
extends AbstractResource {
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    private WorkDataFactory workDataFactory;
    private ProjectHistoryService projectHistoryService;
    private ProjectEntryTransformer projectEntryTransformer;
    private RapidViewService rapidViewService;
    private final WorkflowService workflowService;
    private final CardColorQueryService cardColorQueryService;

    public WorkResource(RapidIssueEntryQueryService rapidIssueEntryQueryService, WorkDataFactory workDataFactory, ProjectHistoryService projectHistoryService, ProjectEntryTransformer projectEntryTransformer, RapidViewService rapidViewService, WorkflowService workflowService, CardColorQueryService cardColorQueryService) {
        this.rapidIssueEntryQueryService = rapidIssueEntryQueryService;
        this.workDataFactory = workDataFactory;
        this.projectHistoryService = projectHistoryService;
        this.projectEntryTransformer = projectEntryTransformer;
        this.rapidViewService = rapidViewService;
        this.workflowService = workflowService;
        this.cardColorQueryService = cardColorQueryService;
    }

    @GET
    @Path(value="/allData")
    public Response getPoolData(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="selectedProjectKey") String selectedProjectKey, final @QueryParam(value="activeQuickFilters") Set<Long> activeQuickFilters, final @QueryParam(value="activeSprints") Set<Long> activeSprints, final @QueryParam(value="etag") String etag) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = WorkResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = WorkResource.this.rapidViewService.getRapidView(user, rapidViewId);
                WorkResource.this.check(rapidView);
                ServiceOutcome<WorkData> workData = WorkResource.this.workDataFactory.getAllData(user, rapidView.getValue(), activeQuickFilters, activeSprints, etag);
                WorkResource.this.check(workData);
                if (workData.getValue().etagData.isUpToDate(etag)) {
                    return WorkResource.this.createOkResponse(workData.getValue());
                }
                if (!WorkResource.this.isGadgetRequest()) {
                    WorkResource.this.registerRecentProjects(user, rapidView.getValue(), workData.getValue().issuesData.projects, selectedProjectKey);
                }
                return WorkResource.this.createOkResponse(workData.getValue());
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{rapidView}/colors")
    public Response getColorData(@PathParam(value="rapidView") Long rapidViewId, ColorsRequestBean requestBean) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
            this.check(rapidView);
            ServiceOutcome<Map<Long, CardColor>> colors = requestBean.getIssues() != null ? this.cardColorQueryService.getCardColorsForIssues(user, rapidView.get(), requestBean.getIssues()) : this.cardColorQueryService.getCardColorsForIssues(user, rapidView.get());
            this.check(colors);
            return this.createOkResponse(WorkColorsResponse.toWorkColorsResponse(colors.get()));
        });
    }

    @GET
    @Path(value="/transitions")
    public Response getTransitions(@QueryParam(value="projectId") List<Long> projectIds) {
        WorkflowService.WorkTransitions result = this.check(this.workflowService.getTransitions(this.getUser(), projectIds));
        return this.response(() -> this.createOkResponse(WorkTransitionsResponse.toWorkTransitionsResponse(result)));
    }

    @GET
    @Path(value="/issue")
    public Response getIssue(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="issueId") Long issueId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidView> rapidView = WorkResource.this.rapidViewService.getRapidView(WorkResource.this.getUser(), rapidViewId);
                WorkResource.this.check(rapidView);
                IssueService.IssueResult issue = ComponentAccessor.getIssueService().getIssue(WorkResource.this.getUser(), issueId);
                ServiceOutcome<CollectIssuesResult> result = WorkResource.this.rapidIssueEntryQueryService.getIssuesById(WorkResource.this.getUser(), rapidView.getValue(), (Set<Long>)ImmutableSet.of((Object)issueId), rapidView.get().showDaysInColumn(), CardLayoutField.Mode.WORK, (Set<Long>)ImmutableSet.of());
                WorkResource.this.check(result);
                CollectIssuesResult collectResult = result.get();
                return WorkResource.this.createOkResponse(new GetIssueResponse(collectResult));
            }
        });
    }

    private void registerRecentProjects(ApplicationUser user, RapidView rapidView, List<ProjectEntry> projectEntries, String selectedProjectKey) {
        ArrayList projectsToRegister = Lists.newArrayList((Iterable)Iterables.transform(projectEntries, (Function)this.projectEntryTransformer));
        this.projectHistoryService.registerRecentProjects(user, rapidView, projectsToRegister, selectedProjectKey);
    }

    @XmlRootElement
    public static class WorkTransitionEntry
    extends RestTemplate {
        @XmlElement
        public int transitionId;
        @XmlElement
        public Long fromStatusId;
        @XmlElement
        public Long toStatusId;
        @XmlElement
        public String name;
        @XmlElement
        public boolean hasScreen;
        @XmlElement
        public boolean hasConditions;
        @XmlElement
        public boolean hasValidators;
        @XmlElement
        public boolean isInitial;
        @XmlElement
        public boolean isGlobal;

        public static WorkTransitionEntry toWorkTransitionEntry(TransitionEntry jiraTransitionEntry) {
            WorkTransitionEntry workTransitionEntry = new WorkTransitionEntry();
            workTransitionEntry.transitionId = jiraTransitionEntry.getTransitionId();
            workTransitionEntry.fromStatusId = jiraTransitionEntry.getFromStatusId();
            workTransitionEntry.toStatusId = jiraTransitionEntry.getToStatusId();
            workTransitionEntry.name = jiraTransitionEntry.getName();
            workTransitionEntry.hasScreen = jiraTransitionEntry.getHasScreen();
            workTransitionEntry.hasConditions = jiraTransitionEntry.getHasConditions();
            workTransitionEntry.hasValidators = jiraTransitionEntry.getHasValidators();
            workTransitionEntry.isInitial = jiraTransitionEntry.getIsInitial();
            workTransitionEntry.isGlobal = jiraTransitionEntry.getIsGlobal();
            return workTransitionEntry;
        }
    }

    @XmlRootElement
    static class WorkTransitionsResponse
    extends RestTemplate {
        @XmlElement
        public Map<Long, Map<String, String>> projectAndIssueTypeToWorkflow;
        @XmlElement
        public Map<String, Collection<WorkTransitionEntry>> workflowToTransitions;

        WorkTransitionsResponse() {
        }

        static WorkTransitionsResponse toWorkTransitionsResponse(WorkflowService.WorkTransitions workTransitions) {
            WorkTransitionsResponse workTransitionsResponse = new WorkTransitionsResponse();
            workTransitionsResponse.projectAndIssueTypeToWorkflow = workTransitions.getProjectAndIssueTypeToWorkflow();
            Collection<WorkflowTransitionEntry> workflowTransitionEntries = workTransitions.getWorkflowTransitionEntries();
            workTransitionsResponse.workflowToTransitions = workflowTransitionEntries.stream().collect(Collectors.toMap(workflowTransitionEntry -> workflowTransitionEntry.getWorkflow().getName(), WorkTransitionsResponse::toWorkTransitionEntries));
            return workTransitionsResponse;
        }

        private static Collection<WorkTransitionEntry> toWorkTransitionEntries(WorkflowTransitionEntry workflowTransitionEntry) {
            return workflowTransitionEntry.getTransitions().stream().map(WorkTransitionEntry::toWorkTransitionEntry).collect(Collectors.toList());
        }
    }

    @XmlRootElement
    public static class GetIssueResponse
    extends RestTemplate {
        @XmlElement
        public RapidIssueEntry issue;
        @XmlElement
        public EntityData entityData;

        public GetIssueResponse(CollectIssuesResult collectResult) {
            this((RapidIssueEntry)Iterables.getOnlyElement(collectResult.getIssues()), collectResult.getEntityData());
        }

        public GetIssueResponse(RapidIssueEntry issue, EntityData entityData) {
            this.issue = issue;
            this.entityData = entityData;
        }
    }

    @XmlRootElement
    static class WorkColorsResponse
    extends RestTemplate {
        @XmlElement
        public Map<Long, String> colors;

        public WorkColorsResponse(Map<Long, String> colors) {
            this.colors = colors;
        }

        static WorkColorsResponse toWorkColorsResponse(Map<Long, CardColor> colors) {
            return new WorkColorsResponse(colors.entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ColorUtils.colorToHex(((CardColor)e.getValue()).getColor()))));
        }
    }

    public static final class ColorsRequestBean {
        @JsonProperty
        private List<Long> issues;

        public ColorsRequestBean() {
        }

        public ColorsRequestBean(List<Long> issues) {
            this.issues = issues;
        }

        public List<Long> getIssues() {
            return this.issues;
        }

        public void setIssues(List<Long> issues) {
            this.issues = issues;
        }
    }
}

