/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.work;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.query.QueryUtils;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.callback.IssueCountAndLastUpdatedCollector;
import com.atlassian.greenhopper.service.rapid.EmptyFilterQueryWrapper;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.util.jql.EpicsQueryHelper;
import com.atlassian.greenhopper.web.rapid.RapidBoardViewModelFactory;
import com.atlassian.greenhopper.web.rapid.RapidViewConfig;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.EntityData;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.work.ActiveFilterData;
import com.atlassian.greenhopper.web.rapid.work.ColumnsData;
import com.atlassian.greenhopper.web.rapid.work.IssuesData;
import com.atlassian.greenhopper.web.rapid.work.OrderData;
import com.atlassian.greenhopper.web.rapid.work.PoolService;
import com.atlassian.greenhopper.web.rapid.work.SprintsData;
import com.atlassian.greenhopper.web.rapid.work.SwimlanesData;
import com.atlassian.greenhopper.web.rapid.work.SwimlanesDataFactory;
import com.atlassian.greenhopper.web.rapid.work.WorkData;
import com.atlassian.greenhopper.web.rapid.work.WorkFilters;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkDataFactory {
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private PoolService poolService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RapidBoardViewModelFactory rapidBoardViewModelFactory;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private SwimlanesDataFactory swimlanesDataFactory;
    @Autowired
    private EpicsQueryHelper epicsQueryHelper;
    @Autowired
    private JiraBaseUrls jiraBaseUrls;
    @Autowired
    private SearchService searchService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    ArchivingLicenseCheck archivingLicenseCheck;

    public ServiceOutcome<WorkData> getAllData(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters, Set<Long> activeSprints, String etag) {
        ServiceOutcome<Long> epicsCountOutcome;
        WorkData workData = new WorkData();
        workData.rapidViewId = rapidView.getId();
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<Result> workDataIssueCountAndLastUpdatedOutcome = this.getWorkDataIssueCountAndLastUpdated(user, rapidView);
        if (workDataIssueCountAndLastUpdatedOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(workDataIssueCountAndLastUpdatedOutcome);
        }
        workData.emptyFilterBoard = workDataIssueCountAndLastUpdatedOutcome.getValue().emptyFilterBoard;
        Integer issueCount = workDataIssueCountAndLastUpdatedOutcome.getValue().issueCount;
        DateTime issueLastUpdated = workDataIssueCountAndLastUpdatedOutcome.getValue().lastUpdatedDate;
        workData.etagData = this.createWorkDataEtag(rapidView, activeQuickFilters, activeSprints, issueCount, issueLastUpdated, workData.emptyFilterBoard);
        if (workData.etagData.isUpToDate(etag)) {
            return ServiceOutcomeImpl.ok(workData);
        }
        ServiceOutcome<WorkFilters> workFilters = this.getWorkFilters(user, rapidView, activeQuickFilters, activeSprints);
        if (!workFilters.isValid()) {
            return ServiceOutcomeImpl.error(workFilters);
        }
        ServiceOutcome<PoolService.ColumnConstraintsData> columnConstraintsData = this.poolService.getColumnConstraintsData(user, rapidView);
        if (columnConstraintsData.isInvalid()) {
            return ServiceOutcomeImpl.error(columnConstraintsData);
        }
        workData.columnsData = this.toColumnsData(i18n, rapidView, columnConstraintsData.getValue().getColumnStatistics(), user, workFilters.get());
        ServiceOutcome<CollectIssuesResult> workModeIssues = this.rapidIssueEntryQueryService.collectWorkModeIssues(user, rapidView, workFilters.getValue());
        ServiceOutcome<CollectIssuesResult> missingParents = this.rapidIssueEntryQueryService.getMissingParents(user, rapidView, workModeIssues.getValue().getIssues(), CardLayoutField.Mode.WORK);
        ServiceOutcome<IssuesData> issuesData = this.getOrderedIssuesData(user, rapidView, workFilters.getValue(), workModeIssues, missingParents);
        if (!issuesData.isValid()) {
            return ServiceOutcomeImpl.error(issuesData);
        }
        EntityData missingParentsEntityData = missingParents.get().getEntityData();
        workData.issuesData = issuesData.getValue();
        workData.entityData = workModeIssues.get().getEntityData();
        workData.entityData.epics.putAll(missingParentsEntityData.epics);
        workData.entityData.statuses.putAll(missingParentsEntityData.statuses);
        workData.entityData.types.putAll(missingParentsEntityData.types);
        workData.entityData.priorities.putAll(missingParentsEntityData.priorities);
        ServiceOutcome<OrderData> orderData = this.getOrderData(user, rapidView, workData.issuesData);
        if (!orderData.isValid()) {
            return ServiceOutcomeImpl.error(orderData);
        }
        workData.orderData = orderData.getValue();
        ServiceOutcome<SwimlanesData> swimlanesData = this.swimlanesDataFactory.loadSwimlanesData(user, rapidView, i18n, workFilters.getValue(), issuesData.getValue());
        if (!swimlanesData.isValid()) {
            return ServiceOutcomeImpl.error(swimlanesData);
        }
        workData.swimlanesData = swimlanesData.getValue();
        ServiceOutcome<RapidViewConfig.StatisticsConfig> config = this.rapidBoardViewModelFactory.getStatisticsConfig(rapidView, i18n);
        if (!config.isValid()) {
            return ServiceOutcomeImpl.error(config);
        }
        workData.statistics = config.getValue();
        ServiceOutcome<SprintsData> sprintsData = this.loadOpenSprintsData(user, rapidView);
        if (!sprintsData.isValid()) {
            return ServiceOutcomeImpl.error(sprintsData);
        }
        workData.sprintsData = sprintsData.getValue();
        workData.epicData = new WorkData.WorkModeEpicData();
        workData.epicData.epicsCount = -1;
        ServiceOutcome<JqlQueryBuilder> epicsQueryOutcome = this.epicsQueryHelper.getEpicsQuery(user, rapidView);
        if (epicsQueryOutcome.isValid() && (epicsCountOutcome = this.issueDataService.count(user, epicsQueryOutcome.get().buildQuery())).isValid()) {
            workData.epicData.epicsCount = epicsCountOutcome.get().intValue();
        }
        workData.cardColorStrategy = rapidView.getCardColorStrategy().getId();
        return ServiceOutcomeImpl.ok(workData);
    }

    private ServiceOutcome<Result> getWorkDataIssueCountAndLastUpdated(ApplicationUser user, RapidView rapidView) {
        IssueCountAndLastUpdatedCollector collector;
        ServiceOutcome<Query> queryOutcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        Query query = QueryUtils.clearOrderByClause(queryOutcome.getValue()).buildQuery();
        ServiceOutcome<Void> findOutcome = this.issueDataService.findWithServiceOutcome(user, query, collector = new IssueCountAndLastUpdatedCollector());
        if (findOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(findOutcome);
        }
        Integer issueCount = collector.getIssueCount();
        DateTime lastUpdated = collector.getLastUpdatedDate();
        if (rapidView.getSwimlaneStrategy().equals((Object)SwimlaneStrategy.EPIC)) {
            ServiceOutcome<DateTime> epicsLastUpdatedOutcome = this.rapidIssueEntryQueryService.getEpicsLastUpdated(user, rapidView);
            if (epicsLastUpdatedOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(epicsLastUpdatedOutcome);
            }
            if (lastUpdated.isBefore((ReadableInstant)epicsLastUpdatedOutcome.getValue())) {
                lastUpdated = epicsLastUpdatedOutcome.getValue();
            }
        }
        return ServiceOutcomeImpl.ok(new Result(issueCount, lastUpdated, queryOutcome.getValue() instanceof EmptyFilterQueryWrapper));
    }

    private WorkData.ETagData createWorkDataEtag(RapidView rapidView, Set<Long> activeQuickFilters, Set<Long> activeSprints, Integer issueCount, DateTime lastUpdated, Boolean emptyFilterBoard) {
        WorkData.ETagData etagData = new WorkData.ETagData();
        etagData.rapidViewId = rapidView.getId();
        etagData.lastUpdated = lastUpdated.getMillis();
        etagData.issueCount = issueCount;
        etagData.quickFilters = activeQuickFilters != null ? activeQuickFilters.toString() : "";
        etagData.sprints = activeSprints != null ? activeSprints.toString() : "";
        etagData.emptyFilterBoard = emptyFilterBoard;
        etagData.generateETag();
        return etagData;
    }

    private ServiceOutcome<WorkFilters> getWorkFilters(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters, Set<Long> activeSprints) {
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (!quickFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        ServiceOutcome<ClauseToAdd> sprintsClause = this.rapidViewQueryService.getSprintFilterClause(user, rapidView, activeSprints);
        if (!sprintsClause.isValid()) {
            return ServiceOutcomeImpl.error(sprintsClause);
        }
        ServiceOutcome<ClauseToAdd> kanbanBacklogFilterClause = this.rapidViewQueryService.getKanbanBacklogFilterClause(user, rapidView);
        if (!kanbanBacklogFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(kanbanBacklogFilterClause);
        }
        ServiceOutcome<ClauseToAdd> kanbanDoneColumnFilterClause = this.rapidViewQueryService.getKanbanDoneColumnFilterClause(user, rapidView);
        if (!kanbanBacklogFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(kanbanBacklogFilterClause);
        }
        WorkFilters workFilters = new WorkFilters(activeQuickFilters, activeSprints, quickFilterClause.getValue(), sprintsClause.getValue(), kanbanBacklogFilterClause.getValue(), kanbanDoneColumnFilterClause.getValue());
        return ServiceOutcomeImpl.ok(workFilters);
    }

    private ServiceOutcome<SprintsData> loadOpenSprintsData(ApplicationUser user, RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.ok();
        }
        ServiceOutcome<Pair<List<Sprint>, Set<Long>>> sprintsAndBacklogProjects = this.rapidViewQueryService.getOpenSprintsAndBacklogProjects(user, rapidView);
        if (!sprintsAndBacklogProjects.isValid()) {
            return ServiceOutcomeImpl.error(sprintsAndBacklogProjects);
        }
        EnumSet<Sprint.State> activeSprintsEnum = EnumSet.of(Sprint.State.ACTIVE);
        ServiceOutcome<Collection<Sprint>> activeBoardOwnedSprints = this.sprintManager.getSprintsForView(rapidView.getId(), activeSprintsEnum);
        if (!activeBoardOwnedSprints.isValid()) {
            return ServiceOutcomeImpl.error(activeBoardOwnedSprints);
        }
        List<Sprint> sprints = SprintUtils.getFilteredAndSortedSprints(activeSprintsEnum, (Collection)sprintsAndBacklogProjects.getValue().left(), activeBoardOwnedSprints.getValue());
        boolean canManageSprints = this.sprintPermissionService.hasManageSprintsPermission(user, rapidView);
        SprintsData sprintsData = new SprintsData();
        sprintsData.rapidViewId = rapidView.getId();
        sprintsData.sprints = this.sprintEntryFactory.newEditTransformer(user, rapidView).apply(sprints);
        sprintsData.canManageSprints = canManageSprints;
        return ServiceOutcomeImpl.ok(sprintsData);
    }

    private ColumnsData toColumnsData(I18n2 i18n, RapidView rapidView, Map<Column, Double> columnStatisticData, ApplicationUser user, WorkFilters workFilters) {
        List<Column> columns = this.columnService.getVisibleColumns(rapidView);
        ColumnsData columnsData = new ColumnsData();
        columnsData.rapidViewId = rapidView.getId();
        for (Column column : columns) {
            if (column.getStatusIds().isEmpty() || KanbanBacklogColumn.isKanbanBacklogColumn(column)) continue;
            ColumnsData.ColumnEntry entry = new ColumnsData.ColumnEntry();
            entry.id = column.getId();
            entry.name = i18n.getText(column.getName());
            entry.min = column.getMin();
            entry.max = column.getMax();
            entry.statusIds = column.getStatusIds();
            entry.limitJql = this.getColumnLimitJql(column, user, rapidView);
            if (columnStatisticData.containsKey(column)) {
                entry.statisticsFieldValue = columnStatisticData.get(column);
            }
            columnsData.columns.add(entry);
        }
        return columnsData;
    }

    @Nullable
    private String getColumnLimitJql(Column column, ApplicationUser user, RapidView rapidView) {
        if (this.featureManager.isEnabled(SoftwareFeatureFlags.KANBAN_HIDE_OLD_DONE_ISSUES) && rapidView.isOldDoneIssuesCutoffSpecified() && this.hasDoneStatuses(column, user)) {
            Query query;
            ServiceOutcome<String> jqlString;
            ServiceOutcome<Query> columnQuery = this.rapidViewQueryService.getWorkModeQuery(user, rapidView, column);
            ServiceOutcome<ClauseToAdd> fastKanbanFilter = this.rapidViewQueryService.getKanbanDoneColumnFilterClause(user, rapidView);
            if (columnQuery.isValid() && fastKanbanFilter.isValid() && (jqlString = this.searchService.getJqlString(query = JqlQueryBuilder.newBuilder((Query)columnQuery.get()).where().and().not().addClause(fastKanbanFilter.getValue().getClause()).buildQuery())).isValid()) {
                return this.jiraBaseUrls.baseUrl() + "/issues/?jql=" + this.encodeJql(jqlString.get());
            }
        }
        return null;
    }

    private String encodeJql(String query) {
        try {
            return URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLEncoder.encode(query);
        }
    }

    private boolean hasDoneStatuses(Column column, ApplicationUser user) {
        return !this.columnService.getDoneStatuses(column, user).isEmpty();
    }

    private static ArrayList<ActiveFilterData> toActiveFilterData(Set<Long> activeQuickFilters) {
        ArrayList<ActiveFilterData> filters = new ArrayList<ActiveFilterData>();
        for (Long qf : activeQuickFilters) {
            ActiveFilterData d = new ActiveFilterData();
            d.id = qf;
            filters.add(d);
        }
        return filters;
    }

    private ServiceOutcome<IssuesData> getOrderedIssuesData(ApplicationUser user, RapidView rapidView, WorkFilters filters, ServiceOutcome<CollectIssuesResult> issuesResult, ServiceOutcome<CollectIssuesResult> missingParentsIssuesResult) {
        ServiceOutcome<CollectIssuesResult> issuesInOrder = issuesResult;
        if (!issuesInOrder.isValid()) {
            return ServiceOutcomeImpl.error(issuesInOrder);
        }
        if (!missingParentsIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(missingParentsIssuesResult);
        }
        IssuesData issuesData = new IssuesData();
        issuesData.rapidViewId = rapidView.getId();
        issuesData.activeFilters = WorkDataFactory.toActiveFilterData(filters.getActiveQuickFilters());
        issuesData.issues = issuesInOrder.getValue().getIssues();
        issuesData.projects = issuesInOrder.getValue().getProjects();
        issuesData.missingParents = ImmutableSet.copyOf(missingParentsIssuesResult.get().getIssues());
        issuesData.hasBulkChangePermission = this.permissionService.hasGlobalPermission(user, GlobalPermissionKey.BULK_CHANGE);
        issuesData.issueArchivingEnabled = this.archivingLicenseCheck.isLicensedForIssueArchiving();
        if (!rapidView.isSprintSupportEnabled()) {
            ServiceOutcome<Boolean> canRelease = this.canRelease(user, issuesData);
            if (!canRelease.isValid()) {
                return ServiceOutcomeImpl.error(canRelease);
            }
            issuesData.canRelease = canRelease.getValue();
        }
        return ServiceOutcomeImpl.ok(issuesData);
    }

    private ServiceOutcome<Boolean> canRelease(ApplicationUser user, IssuesData issuesData) {
        HashSet<Project> projects = new HashSet<Project>();
        for (ProjectEntry entry : issuesData.projects) {
            ProjectService.GetProjectResult projectById = this.projectService.getProjectById(user, entry.id);
            if (projectById.getErrorCollection().hasAnyErrors()) {
                return ServiceOutcomeImpl.from(projectById.getErrorCollection());
            }
            projects.add(projectById.getProject());
        }
        if (projects.isEmpty()) {
            return ServiceOutcomeImpl.ok(false);
        }
        return ServiceOutcomeImpl.ok(this.permissionService.isProjectAdministrator(user, projects));
    }

    private ServiceOutcome<OrderData> getOrderData(final ApplicationUser user, RapidView rapidView, IssuesData issuesData) {
        OrderData orderData = new OrderData();
        orderData.rapidViewId = rapidView.getId();
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        ServiceOutcome<CustomField> sortedByRankField = ServiceOutcomes.flatMap(savedFilter, new Function<SearchRequest, ServiceOutcome<CustomField>>(){

            public ServiceOutcome<CustomField> apply(SearchRequest savedFilter) {
                return WorkDataFactory.this.lexoRankCustomFieldService.getValidatedCustomFieldSortedByRankField(user, savedFilter.getQuery());
            }
        });
        orderData.rankable = sortedByRankField.isValid();
        if (orderData.rankable) {
            CustomField rankField = sortedByRankField.getValue();
            orderData.rankCustomFieldId = rankField.getIdAsLong();
            orderData.canRankPerProject = new ArrayList<OrderData.PerProjectRankPermission>();
            for (ProjectEntry prjEntry : issuesData.projects) {
                ProjectService.GetProjectResult projectResult = this.projectService.getProjectById(user, prjEntry.id);
                if (!projectResult.isValid()) continue;
                Project project = projectResult.getProject();
                boolean canRank = this.permissionService.hasPermission(user, project, 28);
                OrderData.PerProjectRankPermission permission = new OrderData.PerProjectRankPermission();
                permission.canRank = canRank;
                permission.projectKey = project.getKey();
                permission.projectId = project.getId();
                orderData.canRankPerProject.add(permission);
            }
        }
        return ServiceOutcomeImpl.ok(orderData);
    }

    private class Result {
        final int issueCount;
        final DateTime lastUpdatedDate;
        final boolean emptyFilterBoard;

        public Result(int issueCount, DateTime lastUpdatedDate, boolean emptyFilterBoard) {
            this.issueCount = issueCount;
            this.lastUpdatedDate = lastUpdatedDate;
            this.emptyFilterBoard = emptyFilterBoard;
        }
    }
}

