/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.work;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.greenhopper.web.rapid.work.ActiveFilterData;
import com.atlassian.greenhopper.web.rapid.work.IssuesData;
import com.atlassian.greenhopper.web.rapid.work.ParentSwimlanesData;
import com.atlassian.greenhopper.web.rapid.work.PoolService;
import com.atlassian.greenhopper.web.rapid.work.SwimlanesData;
import com.atlassian.greenhopper.web.rapid.work.WorkFilters;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwimlanesDataFactory {
    @Autowired
    private PoolService poolService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private AvatarService avatarService;

    public ServiceOutcome<SwimlanesData> loadSwimlanesData(ApplicationUser user, RapidView rapidView, I18n2 i18n, WorkFilters workFilters, IssuesData issuesData) {
        SwimlanesData data = new SwimlanesData();
        data.rapidViewId = rapidView.getId();
        SwimlaneStrategy swimlaneStrategy = rapidView.getSwimlaneStrategy();
        data.swimlaneStrategy = swimlaneStrategy.getId();
        switch (swimlaneStrategy) {
            case CUSTOM: {
                ServiceOutcome<SwimlanesData.CustomSwimlanesData> customSwimlanes = this.calculateCustomSwimlanes(issuesData, user, rapidView, workFilters, i18n);
                if (customSwimlanes.isInvalid()) {
                    return ServiceOutcomeImpl.error(customSwimlanes);
                }
                data.customSwimlanesData = customSwimlanes.get();
                break;
            }
            case PARENT_CHILD: {
                ServiceOutcome<SwimlanesData.ParentSwimlanesData> parentData = this.calculateParentSwimlanes(issuesData, user, rapidView);
                if (parentData.isInvalid()) {
                    return ServiceOutcomeImpl.error(parentData);
                }
                data.parentSwimlanesData = parentData.get();
                break;
            }
            case EPIC: {
                ServiceOutcome<SwimlanesData.EpicSwimlanesData> epicSwimlanesData = this.calculateEpicSwimlanes(issuesData, user, rapidView);
                if (epicSwimlanesData.isInvalid()) {
                    return ServiceOutcomeImpl.error(epicSwimlanesData);
                }
                data.epicSwimlanesData = epicSwimlanesData.get();
                break;
            }
            case PROJECT: {
                this.calculateProjectSwimlanes(issuesData);
            }
        }
        return ServiceOutcomeImpl.ok(data);
    }

    private ServiceOutcome<SwimlanesData.CustomSwimlanesData> calculateCustomSwimlanes(IssuesData issuesData, ApplicationUser user, RapidView rapidView, WorkFilters workFilters, I18n2 i18n) {
        Set<Long> validIssueIds = this.toValidIssueIds(issuesData);
        ServiceOutcome<List<PoolService.SwimlaneIssuesData>> swimlanesIssues = this.poolService.getCustomSwimlanes(user, rapidView, workFilters, validIssueIds);
        if (!swimlanesIssues.isValid()) {
            return ServiceOutcomeImpl.error(swimlanesIssues);
        }
        SwimlanesData.CustomSwimlanesData customData = new SwimlanesData.CustomSwimlanesData();
        customData.activeFilters = SwimlanesDataFactory.toActiveFilterData(workFilters.getActiveQuickFilters());
        customData.swimlanes = this.toSwimlaneEntries(user, i18n, swimlanesIssues.getValue());
        return ServiceOutcomeImpl.ok(customData);
    }

    private ServiceOutcome<SwimlanesData.ParentSwimlanesData> calculateParentSwimlanes(IssuesData issuesData, ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<ParentSwimlanesData> parentResult = this.poolService.getParentSwimlanesData(user, rapidView, issuesData.issues, issuesData.missingParents);
        if (!parentResult.isValid()) {
            return ServiceOutcomeImpl.error(parentResult);
        }
        SwimlanesData.ParentSwimlanesData parentData = new SwimlanesData.ParentSwimlanesData();
        parentData.parentIssueIds = parentResult.getValue().getParentIssueIds();
        parentData.doneCandidates = parentResult.getValue().getDoneCandidates();
        parentData.inprogressCandidates = parentResult.getValue().getInprogressCandidates();
        return ServiceOutcomeImpl.ok(parentData);
    }

    private ServiceOutcome<SwimlanesData.EpicSwimlanesData> calculateEpicSwimlanes(IssuesData issuesData, ApplicationUser user, RapidView rapidView) {
        Set<String> validEpicKeys = this.toValidEpicKeys(issuesData);
        ServiceOutcome<CollectIssuesResult> epicIssuesResult = this.rapidIssueEntryQueryService.collectEpicIssues(user, rapidView);
        if (epicIssuesResult.isInvalid()) {
            return ServiceOutcomeImpl.error(epicIssuesResult);
        }
        SwimlanesData.EpicSwimlanesData epicSwimlanesData = new SwimlanesData.EpicSwimlanesData();
        for (RapidIssueEntry epic : epicIssuesResult.getValue().getIssues()) {
            if (!validEpicKeys.contains(epic.key)) continue;
            epicSwimlanesData.epics.add(epic.key);
            epicSwimlanesData.epicNames.put(epic.key, epic.epicLabel);
        }
        return ServiceOutcomeImpl.ok(epicSwimlanesData);
    }

    @VisibleForTesting
    void calculateProjectSwimlanes(IssuesData issuesData) {
        issuesData.projects.stream().forEach(projectEntry -> {
            Project projectObj = this.projectManager.getProjectObj(projectEntry.id);
            projectEntry.key = projectObj.getKey();
            projectEntry.name = projectObj.getName();
            projectEntry.avatarUrl = this.avatarService.getProjectAvatarURL(projectObj, Avatar.Size.SMALL);
        });
    }

    private Set<Long> toValidIssueIds(IssuesData data) {
        return data.issues.stream().map(RapidIssueEntry::getIssueId).collect(Collectors.toSet());
    }

    private Set<String> toValidEpicKeys(IssuesData data) {
        return data.issues.stream().map(entry -> entry.epic).filter(epic -> epic != null).collect(Collectors.toSet());
    }

    private List<SwimlanesData.SwimlaneEntry> toSwimlaneEntries(ApplicationUser user, I18n2 i18n, List<PoolService.SwimlaneIssuesData> swimlanes) {
        ArrayList<SwimlanesData.SwimlaneEntry> result = new ArrayList<SwimlanesData.SwimlaneEntry>();
        for (PoolService.SwimlaneIssuesData swimlaneData : swimlanes) {
            Swimlane swimlane = swimlaneData.getSwimlane();
            SwimlanesData.SwimlaneEntry d = new SwimlanesData.SwimlaneEntry();
            d.id = swimlane.getId();
            d.defaultSwimlane = swimlane.isDefaultLane();
            d.name = i18n.getText(swimlane.getName());
            d.query = this.jqlHelper.getSanitisedQueryString(user, swimlane.getQuery());
            d.description = i18n.getText(swimlane.getDescription());
            d.issueIds = swimlaneData.getIssueIds();
            d.maxIssuesExceeded = swimlaneData.isMaxIssuesExceeded();
            result.add(d);
        }
        return result;
    }

    private static ArrayList<ActiveFilterData> toActiveFilterData(Set<Long> activeQuickFilters) {
        ArrayList<ActiveFilterData> filters = new ArrayList<ActiveFilterData>();
        for (Long qf : activeQuickFilters) {
            ActiveFilterData d = new ActiveFilterData();
            d.id = qf;
            filters.add(d);
        }
        return filters;
    }
}

