/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.work;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.query.QueryUtils;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.AbstractColumnStatisticsCallback;
import com.atlassian.greenhopper.service.issue.callback.ColumnStatisticsCallbackFactory;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueIdNumericCollector;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.web.rapid.issue.IssueSubtasksResolved;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntryFactory;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.work.ParentSwimlanesData;
import com.atlassian.greenhopper.web.rapid.work.ParentSwimlanesDataCallback;
import com.atlassian.greenhopper.web.rapid.work.PoolService;
import com.atlassian.greenhopper.web.rapid.work.WorkFilters;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PoolServiceImpl
implements PoolService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private JqlQueryParser jqlQueryParser;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private SwimlaneService swimlaneService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private ColumnStatisticsCallbackFactory columnStatisticsCallbackFactory;
    @Autowired
    private TransitionEntryFactory transitionEntryFactory;
    protected final LoggerWrapper performanceLogger = LoggerWrapper.with("com.atlassian.greenhopper.performance");

    @Override
    @Nonnull
    public ServiceOutcome<List<PoolService.SwimlaneIssuesData>> getCustomSwimlanes(ApplicationUser user, RapidView rapidView, WorkFilters workFilters, Set<Long> validIssues) {
        long start = System.currentTimeMillis();
        start = System.currentTimeMillis();
        ServiceOutcome<LinkedHashMap<Swimlane, Set<Long>>> swimlaneIssueIds = this.getSwimlaneIssueIds(user, rapidView, workFilters);
        if (!swimlaneIssueIds.isValid()) {
            return ServiceOutcomeImpl.error(swimlaneIssueIds);
        }
        this.perfLog("swimlane issue ids", start);
        ArrayList<PoolService.SwimlaneIssuesData> swimlaneData = new ArrayList<PoolService.SwimlaneIssuesData>();
        for (Map.Entry<Swimlane, Set<Long>> entry : swimlaneIssueIds.getValue().entrySet()) {
            Swimlane swimlane = entry.getKey();
            Set<Long> issueIds = entry.getValue();
            boolean maxIssuesExceeded = issueIds.retainAll(validIssues);
            swimlaneData.add(new PoolService.SwimlaneIssuesData(swimlane, issueIds, maxIssuesExceeded));
        }
        return ServiceOutcomeImpl.ok(swimlaneData);
    }

    @Override
    @Nonnull
    public ServiceOutcome<PoolService.ColumnConstraintsData> getColumnConstraintsData(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<StatisticsFieldConfig> statisticsField = this.statisticsFieldService.loadStatisticsField(rapidView);
        if (!statisticsField.isValid()) {
            return ServiceOutcomeImpl.error(statisticsField);
        }
        if (statisticsField.getValue().getType() == StatisticsFieldConfig.Type.NONE) {
            this.log.debug("Rapid View '%s' [%d] does not have a statistics field set - no collection of column statistics required", rapidView.getName(), rapidView.getId());
            return ServiceOutcomeImpl.ok(new PoolService.ColumnConstraintsData(MapBuilder.emptyMap()));
        }
        this.log.debug("Rapid View '%s' [%d] has statistics field set to '%s' - collecting column statistics", rapidView.getName(), rapidView.getId(), statisticsField.getValue());
        return this.getColumnStatisticsData(user, rapidView, statisticsField.getValue());
    }

    private ServiceOutcome<PoolService.ColumnConstraintsData> getColumnStatisticsData(ApplicationUser user, RapidView rapidView, StatisticsFieldConfig statisticsField) {
        AbstractColumnStatisticsCallback columnStatisticsCallback = this.columnStatisticsCallbackFactory.createCallback(rapidView, statisticsField);
        ServiceOutcome<Void> outcome = this.executeWorkModeCallback(user, rapidView, columnStatisticsCallback);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(new PoolService.ColumnConstraintsData(columnStatisticsCallback.getStatisticsValuesByColumn()));
    }

    private ServiceOutcome<Void> executeWorkModeCallback(ApplicationUser user, RapidView rapidView, IssueDataCallback callback) {
        ServiceOutcome<Query> queryOutcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        Query query = QueryUtils.clearOrderByClause(queryOutcome.getValue()).buildQuery();
        ServiceOutcome<Void> findOutcome = this.issueDataService.findWithServiceOutcome(user, query, callback);
        if (!findOutcome.isValid()) {
            return ServiceOutcomeImpl.error(findOutcome);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<IssueSubtasksResolved> areIssueSubtasksInFinalColumn(ApplicationUser user, RapidView rapidView, Long issueId) {
        HashSet<Long> parentIssueIds = new HashSet<Long>();
        parentIssueIds.add(issueId);
        ServiceOutcome<ParentSwimlanesData> parentData = this.getParentSwimlanesDataForPossibleParentIds(user, rapidView, parentIssueIds);
        if (!parentData.isValid()) {
            return ServiceOutcomeImpl.error(parentData);
        }
        boolean doneCandidate = parentData.getValue().getDoneCandidates().contains(issueId);
        return ServiceOutcomeImpl.ok(new IssueSubtasksResolved(issueId, doneCandidate));
    }

    private ServiceOutcome<LinkedHashMap<Swimlane, Set<Long>>> getSwimlaneIssueIds(ApplicationUser user, RapidView rapidView, WorkFilters workFilters) {
        LinkedHashMap swimlaneIssueIds = new LinkedHashMap();
        HashSet visitedIssues = new HashSet();
        ServiceOutcome<Query> queryOutcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        JqlQueryBuilder builder = QueryUtils.clearOrderByClause(queryOutcome.getValue());
        builder = QueryUtils.addClauses(builder, workFilters.getQuickFiltersClause(), workFilters.getSprintClause());
        for (Swimlane swimlane : this.swimlaneService.loadSwimlanes(rapidView)) {
            IssueIdNumericCollector issueIdCollector = new IssueIdNumericCollector();
            ServiceOutcome<ClauseToAdd> swimlaneClause = this.getSwimlaneClause(user, swimlane);
            if (!swimlaneClause.isValid()) {
                return ServiceOutcomeImpl.error(swimlaneClause);
            }
            JqlQueryBuilder swimlaneQuery = QueryUtils.addClauses(builder.buildQuery(), swimlaneClause.getValue());
            this.issueDataService.findWithServiceOutcome(user, swimlaneQuery.buildQuery(), issueIdCollector);
            Set newIds = issueIdCollector.getNumericIssueIds().stream().filter(id -> !visitedIssues.contains(id)).collect(Collectors.toSet());
            visitedIssues.addAll(newIds);
            swimlaneIssueIds.put(swimlane, newIds);
        }
        return ServiceOutcomeImpl.ok(swimlaneIssueIds);
    }

    @Override
    @Nonnull
    public ServiceOutcome<ParentSwimlanesData> getParentSwimlanesData(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> issues, Set<RapidIssueEntry> missingParents) {
        HashSet<Long> possibleParentIds = new HashSet<Long>();
        for (RapidIssueEntry issue : issues) {
            if (issue.getParentId() != null) continue;
            possibleParentIds.add(issue.getIssueId());
        }
        for (RapidIssueEntry issue : missingParents) {
            possibleParentIds.add(issue.getIssueId());
        }
        return this.getParentSwimlanesDataForPossibleParentIds(user, rapidView, possibleParentIds);
    }

    @Nonnull
    private ServiceOutcome<ParentSwimlanesData> getParentSwimlanesDataForPossibleParentIds(ApplicationUser user, RapidView rapidView, Set<Long> possibleParentIds) {
        ServiceOutcome<Query> queryOutcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)queryOutcome.getValue());
        builder.orderBy().clear();
        List<Column> columns = this.columnService.getVisibleColumns(rapidView);
        HashSet<String> doneColumnStatusIds = new HashSet<String>();
        doneColumnStatusIds.addAll(columns.get(columns.size() - 1).getStatusIds());
        HashSet<String> todoColumnStatusIds = new HashSet<String>();
        if (columns.size() > 1) {
            todoColumnStatusIds.addAll(columns.get(0).getStatusIds());
        }
        long start = System.currentTimeMillis();
        ParentSwimlanesDataCallback callback = new ParentSwimlanesDataCallback(todoColumnStatusIds, doneColumnStatusIds, possibleParentIds, user, this.transitionEntryFactory);
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, builder.buildQuery(), callback);
        this.perfLog("ParentSwimlanesDataCallback ", start);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return callback.getParentSwimlanesData();
    }

    private ServiceOutcome<ClauseToAdd> getSwimlaneClause(ApplicationUser user, Swimlane swimlane) {
        try {
            Clause swimlaneClause = this.jqlQueryParser.parseQuery(swimlane.getQuery()).getWhereClause();
            return ServiceOutcomeImpl.ok(ClauseToAdd.clauseToAdd(swimlaneClause));
        }
        catch (JqlParseException e) {
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            this.log.warn("Unable to parse swimlane query, swimlane=%s, query:%s", i18n.getText(swimlane.getName()), swimlane.getQuery());
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.swimlane.invalid.configuration", i18n.getText(swimlane.getName()));
        }
    }

    private void perfLog(String message, long start) {
        if (!this.performanceLogger.isDebugEnabled()) {
            return;
        }
        try {
            this.performanceLogger.debug(message + "  %dms", System.currentTimeMillis() - start);
        }
        catch (RuntimeException e) {
            this.performanceLogger.error("Unable to format message: " + message, new Object[0]);
            this.performanceLogger.exception(e);
        }
    }
}

