/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.work;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.rapid.issue.IssueSubtasksResolved;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.work.ParentSwimlanesData;
import com.atlassian.greenhopper.web.rapid.work.WorkFilters;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public interface PoolService {
    @Nonnull
    public ServiceOutcome<List<SwimlaneIssuesData>> getCustomSwimlanes(ApplicationUser var1, RapidView var2, WorkFilters var3, Set<Long> var4);

    @Nonnull
    public ServiceOutcome<ColumnConstraintsData> getColumnConstraintsData(ApplicationUser var1, RapidView var2);

    @Nonnull
    public ServiceOutcome<IssueSubtasksResolved> areIssueSubtasksInFinalColumn(ApplicationUser var1, RapidView var2, Long var3);

    public ServiceOutcome<ParentSwimlanesData> getParentSwimlanesData(ApplicationUser var1, RapidView var2, List<RapidIssueEntry> var3, Set<RapidIssueEntry> var4);

    public static class SwimlaneIssuesData {
        private Swimlane swimlane;
        private Set<Long> issueIds;
        private boolean maxIssuesExceeded;

        public SwimlaneIssuesData(Swimlane swimlane, Set<Long> issueIds, boolean maxIssuesExceeded) {
            this.swimlane = swimlane;
            this.issueIds = issueIds;
            this.maxIssuesExceeded = maxIssuesExceeded;
        }

        public Swimlane getSwimlane() {
            return this.swimlane;
        }

        public Set<Long> getIssueIds() {
            return this.issueIds;
        }

        public boolean isMaxIssuesExceeded() {
            return this.maxIssuesExceeded;
        }
    }

    public static class ColumnConstraintsData {
        private Map<Column, Double> columnStatistics;

        public ColumnConstraintsData(Map<Column, Double> columnStatistics) {
            this.columnStatistics = columnStatistics;
        }

        public Map<Column, Double> getColumnStatistics() {
            return this.columnStatistics;
        }
    }
}

